/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedSignGeometry
extends Geometry {
    private static final float Y_OFF = 0.109375f;
    private static final float POS = 0.5625f;
    private final Direction dir;
    private final float rotDegrees;

    public FramedSignGeometry(GeometryFactory.Context ctx) {
        int rotation = (Integer)ctx.state().getValue((Property)BlockStateProperties.ROTATION_16);
        this.dir = Direction.from2DDataValue((int)(rotation / 4));
        this.rotDegrees = (float)(rotation % 4) * -22.5f;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir.getAxis() == this.dir.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.setPosition(0.5625f)).apply(Modifiers.offset(Direction.UP, 0.109375f)).apply(Modifiers.rotateCentered(Direction.Axis.Y, this.rotDegrees, false)).export(quadMap.get(null));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getAxis(), 0.5625f)).applyIf(Modifiers.setPosition(0.5f), quadDir == Direction.DOWN).apply(Modifiers.offset(Direction.UP, 0.109375f)).apply(Modifiers.rotateCentered(Direction.Axis.Y, this.rotDegrees, false)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.5f, 0.5625f, 1.0f)).apply(Modifiers.offset(Direction.UP, 0.109375f)).apply(Modifiers.rotateCentered(Direction.Axis.Y, this.rotDegrees, false)).export(quadMap.get(null));
        }
        if (!Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.0f, 0.5625f, 0.609375f)).apply(Modifiers.setPosition(0.5625f)).apply(Modifiers.rotateCentered(Direction.Axis.Y, this.rotDegrees, false)).export(quadMap.get(null));
        } else if (quadDir == Direction.DOWN) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.4375f, 0.4375f, 0.5625f, 0.5625f)).apply(Modifiers.rotateCentered(Direction.Axis.Y, this.rotDegrees, false)).export(quadMap.get(Direction.DOWN));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

