/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pane.CornerStripItemModelInfo;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedCornerStripGeometry
extends Geometry {
    private final Direction dir;
    private final SlopeType type;

    public FramedCornerStripGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (SlopeType)((Object)ctx.state().getValue(PropertyHolder.SLOPE_TYPE));
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.type == SlopeType.HORIZONTAL) {
            if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.0625f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.0625f)).export(quadMap.get(quadDir));
            } else if (quadDir.getAxis() == this.dir.getAxis()) {
                boolean onFace = quadDir == this.dir;
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get((Direction)(onFace ? quadDir : null)));
            } else if (quadDir.getAxis() == this.dir.getClockWise().getAxis()) {
                boolean onFace = quadDir == this.dir.getCounterClockWise();
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get((Direction)(onFace ? quadDir : null)));
            }
        } else {
            boolean top;
            boolean bl = top = this.type == SlopeType.TOP;
            if (quadDir.getAxis() == this.dir.getClockWise().getAxis()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.0625f)).apply(Modifiers.cutSideUpDown(top, 0.0625f)).export(quadMap.get(quadDir));
            } else if (quadDir.getAxis() == this.dir.getAxis()) {
                boolean onFace = quadDir == this.dir;
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get((Direction)(onFace ? quadDir : null)));
            } else if (Utils.isY(quadDir)) {
                boolean onFace = top ? quadDir == Direction.UP : quadDir == Direction.DOWN;
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.0625f)).applyIf(Modifiers.setPosition(0.0625f), !onFace).export(quadMap.get((Direction)(onFace ? quadDir : null)));
            }
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return CornerStripItemModelInfo.INSTANCE;
    }
}

