/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedElevatedInnerSlopedPrismGeometry
extends Geometry {
    private final Direction facing;
    private final Direction orientation;
    private final boolean ySlope;

    public FramedElevatedInnerSlopedPrismGeometry(GeometryFactory.Context ctx) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)ctx.state().getValue(PropertyHolder.FACING_DIR));
        this.facing = cmpDir.direction();
        this.orientation = cmpDir.orientation();
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        boolean yFacing = Utils.isY(this.facing);
        boolean yOrient = Utils.isY(this.orientation);
        Direction quadFace = quad.getDirection();
        if (quadFace == this.facing) {
            boolean up;
            if (this.ySlope && yFacing) {
                up = this.orientation == Direction.UP;
                QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(this.orientation, up ? -45.0f : 45.0f)).export(quadMap.get(null));
                Direction oriCW = this.orientation.getClockWise();
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(oriCW, 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.getOpposite(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(oriCW, up ? -45.0f : 45.0f)).export(quadMap.get(null));
                Direction oriCCW = this.orientation.getCounterClockWise();
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(oriCCW, 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.getOpposite(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(oriCCW, up ? -45.0f : 45.0f)).export(quadMap.get(null));
            } else if (!this.ySlope && !yFacing && yOrient) {
                up = this.orientation == Direction.UP;
                QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
            }
            if (!yFacing && !yOrient) {
                boolean right = this.orientation == this.facing.getClockWise();
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.orientation, 0.5f)).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeHorizontalSlope(right, 45.0f)).export(quadMap.get(null));
                if (!this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.getOpposite(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.getOpposite(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
                }
            } else if (!yFacing) {
                up = this.orientation == Direction.UP;
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(true, 0.5f)).apply(Modifiers.cutSideUpDown(up, 0.0f, 1.0f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(false, 0.5f)).apply(Modifiers.cutSideUpDown(up, 1.0f, 0.0f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).export(quadMap.get(null));
            }
        } else if (quadFace == this.orientation) {
            if (yOrient) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getClockWise(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getCounterClockWise(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                if (this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.facing.getOpposite())).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
                }
            } else if (yFacing) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadFace.getClockWise(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadFace.getCounterClockWise(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                if (!this.ySlope) {
                    boolean up = this.facing == Direction.UP;
                    QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.facing.getOpposite())).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
                }
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
            }
        } else if (quadFace.getAxis() != this.orientation.getAxis() && quadFace.getAxis() != this.facing.getAxis()) {
            if (this.ySlope && !yFacing && !yOrient) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.getOpposite(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.orientation.getOpposite(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
            } else if (!this.ySlope && yFacing) {
                boolean up = this.facing == Direction.UP;
                float top = up ? 1.0f : 0.0f;
                float bottom = up ? 0.0f : 1.0f;
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.getOpposite(), top, bottom)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
            }
        }
    }

    @Override
    public boolean transformAllQuads() {
        if (this.ySlope) {
            return true;
        }
        return Utils.isY(this.facing) || Utils.isY(this.orientation);
    }
}

