/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;

public class FramedInnerThreewayCornerGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final boolean ySlope;

    public FramedInnerThreewayCornerGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == Direction.DOWN && this.top || quadDir == Direction.UP && !this.top) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 1.0f, 0.0f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir.getClockWise() || quadDir == this.dir.getOpposite()) {
            Direction cutDir = quadDir == this.dir.getOpposite() ? this.dir.getClockWise() : this.dir.getOpposite();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 1.0f : 0.0f, this.top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
        }
        if (quadDir == this.dir.getClockWise()) {
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.dir)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).export(quadMap.get(null));
            }
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.top ? Direction.UP : Direction.DOWN)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).export(quadMap.get(null));
        } else if (!this.ySlope && quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.dir.getCounterClockWise())).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && (!this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.dir)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSmallTriangle(this.dir.getCounterClockWise())).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).export(quadMap.get(null));
        }
    }
}

