/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;

public class FramedPyramidSlabGeometry
extends Geometry {
    private static final Vector3f ZERO = new Vector3f();
    private final Direction facing;
    private final boolean ySlope;

    public FramedPyramidSlabGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)BlockStateProperties.FACING);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(this.facing)) {
            boolean up;
            boolean bl = up = this.facing == Direction.UP;
            if (!this.ySlope && quadDir.getAxis() != this.facing.getAxis()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!up, 0.5f)).apply(Modifiers.cutSideLeftRight(false, up ? 0.0f : 1.0f, up ? 1.0f : 0.0f)).apply(Modifiers.cutSideLeftRight(true, up ? 0.0f : 1.0f, up ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
            } else if (this.ySlope && quadDir == this.facing) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    float angle;
                    boolean northeast = dir == Direction.NORTH || dir == Direction.EAST;
                    float f = angle = up ? -45.0f : 45.0f;
                    if (northeast) {
                        angle *= -1.0f;
                    }
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(dir, 0.5f)).apply(Modifiers.cutTopBottom(dir.getCounterClockWise(), 0.0f, 1.0f)).apply(Modifiers.cutTopBottom(dir.getClockWise(), 1.0f, 0.0f)).apply(Modifiers.setPosition(0.5f)).apply(Modifiers.rotateCentered(dir.getClockWise().getAxis(), angle, true)).export(quadMap.get(null));
                }
            }
        } else if (!this.ySlope && quadDir.getAxis() == this.facing.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 1.0f, 0.0f)).apply(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 0.0f, 1.0f)).apply(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && Utils.isY(quadDir)) {
            float angle;
            boolean up = quadDir == Direction.UP;
            float f = angle = up ? 45.0f : -45.0f;
            if (this.facing == Direction.NORTH || this.facing == Direction.EAST) {
                angle *= -1.0f;
            }
            Vector3f origin = this.facing.getOpposite().step().max((Vector3fc)ZERO);
            if (up) {
                origin.add(0.0f, 1.0f, 0.0f);
            }
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing, 0.5f)).apply(Modifiers.cutTopBottom(this.facing.getCounterClockWise(), 0.0f, 1.0f)).apply(Modifiers.cutTopBottom(this.facing.getClockWise(), 1.0f, 0.0f)).apply(Modifiers.rotate(this.facing.getClockWise().getAxis(), origin, angle, true)).export(quadMap.get(null));
        } else if (quadDir.getAxis() == this.facing.getClockWise().getAxis()) {
            boolean right = quadDir == this.facing.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.cutSideUpDown(true, right ? 1.0f : 0.0f, right ? 0.0f : 1.0f)).apply(Modifiers.cutSideUpDown(false, right ? 1.0f : 0.0f, right ? 0.0f : 1.0f)).apply(Modifiers.makeHorizontalSlope(!right, 45.0f)).export(quadMap.get(null));
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }
}

