/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.torch;

import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;

public class FramedTorchGeometry
extends Geometry {
    private static final float MIN = 0.4375f;
    private static final float MAX = 0.5625f;
    private static final float TOP = 0.5f;
    private final BlockState state;
    private final BakedModel baseModel;

    public FramedTorchGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.getRenderTypes(Blocks.TORCH.defaultBlockState(), rand, ModelData.EMPTY);
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData extraData, RenderType layer) {
        List quads = this.baseModel.getQuads(this.state, null, rand, extraData, layer);
        for (BakedQuad quad : quads) {
            if (ClientUtils.isDummyTexture(quad)) continue;
            quadMap.get(null).add(quad);
        }
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            boolean top = quadDir == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.4375f, 0.4375f, 0.5625f, 0.5625f)).applyIf(Modifiers.setPosition(0.5f), top).export(quadMap.get(top ? null : quadDir));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.0f, 0.5625f, 0.5f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

