/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.special.FramedItemFrameBlockEntity;

public class FramedItemFrameRenderer
implements BlockEntityRenderer<FramedItemFrameBlockEntity> {
    private static final double ITEM_Z_OFF = 0.4375;
    private static final float DIR_OFF_MULT = 0.49875f;
    private static final float MAP_SCALE = 0.0078125f;
    private static final double MAX_NAMETAG_DIST_SQR = 4096.0;
    private final ItemRenderer itemRenderer;

    public FramedItemFrameRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.getItemRenderer();
    }

    public void render(FramedItemFrameBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        float yRot;
        poseStack.pushPose();
        Direction dir = ((Direction)be.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite();
        float dirOff = Utils.isPositive(dir) ? 0.0f : 1.0f;
        poseStack.translate((float)dir.getStepX() * 0.49875f + (Utils.isX(dir) ? dirOff : 0.5f), (float)dir.getStepY() * 0.49875f + (Utils.isY(dir) ? dirOff : 0.5f), (float)dir.getStepZ() * 0.49875f + (Utils.isZ(dir) ? dirOff : 0.5f));
        boolean vert = Utils.isY(dir);
        float f = yRot = vert ? 0.0f : dir.toYRot();
        if (vert) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f * (float)dir.getAxisDirection().getStep()));
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yRot));
        ItemStack item = be.getItem();
        MapItemSavedData mapData = MapItem.getSavedData((ItemStack)item, (Level)be.getLevel());
        poseStack.translate(0.0, 0.0, 0.4375);
        float itemRotation = mapData != null ? (float)(be.getRotation() % 4 * 2) : (float)be.getRotation();
        poseStack.mulPose(Axis.ZP.rotationDegrees(itemRotation * 360.0f / 8.0f));
        if (mapData != null) {
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.scale(0.0078125f, 0.0078125f, 0.0078125f);
            poseStack.translate(-64.0, -64.0, -1.0);
            int mapLight = be.isGlowingFrame() ? 15728850 : packedLight;
            MapId mapId = (MapId)item.get(DataComponents.MAP_ID);
            Minecraft.getInstance().gameRenderer.getMapRenderer().render(poseStack, buffer, mapId, mapData, true, mapLight);
        } else {
            poseStack.scale(0.5f, 0.5f, 0.5f);
            int itemLight = be.isGlowingFrame() ? 0xF000F0 : packedLight;
            this.itemRenderer.renderStatic(item, ItemDisplayContext.FIXED, itemLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, be.getLevel(), 0);
        }
        poseStack.popPose();
        FramedItemFrameRenderer.renderCustomItemName(be, poseStack, buffer, packedLight);
    }

    private static void renderCustomItemName(FramedItemFrameBlockEntity be, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ItemStack stack = be.getItem();
        if (!Minecraft.renderNames() || stack.isEmpty() || !stack.has(DataComponents.CUSTOM_NAME)) {
            return;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        if (!be.getBlockPos().equals((Object)hitResult2.getBlockPos())) {
            return;
        }
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        double dist = camera.getPosition().distanceToSqr(hitResult2.getLocation());
        if (dist > 4096.0) {
            return;
        }
        Direction dir = (Direction)be.getBlockState().getValue((Property)BlockStateProperties.FACING);
        float dx = 0.5f + (float)dir.getStepX() * 0.46875f - (float)dir.getStepX() * 0.3f;
        float dz = 0.5f + (float)dir.getStepZ() * 0.46875f - (float)dir.getStepZ() * 0.3f;
        poseStack.pushPose();
        poseStack.translate(dx, 1.25f, dz);
        poseStack.mulPose(camera.rotation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Font font = Minecraft.getInstance().font;
        Component name = stack.getHoverName();
        Matrix4f pose = poseStack.last().pose();
        int alpha = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
        float x = (float)(-font.width((FormattedText)name)) / 2.0f;
        font.drawInBatch(name, x, 0.0f, 0x20FFFFFF, false, pose, buffer, Font.DisplayMode.SEE_THROUGH, alpha, packedLight);
        font.drawInBatch(name, x, 0.0f, -1, false, pose, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }

    public boolean shouldRender(FramedItemFrameBlockEntity be, Vec3 cameraPos) {
        return be.hasItem() && super.shouldRender((BlockEntity)be, cameraPos);
    }
}

