/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.model.ErrorModel;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.client.model.FramedTankItemModel;
import xfacthd.framedblocks.client.render.block.FramedTankRenderer;
import xfacthd.framedblocks.common.FBContent;

public final class TankItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public TankItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext ctx, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        poseStack.popPose();
        poseStack.pushPose();
        boolean validModel = true;
        BakedModel model = renderer.getModel(stack, null, null, 0);
        if (model instanceof FramedTankItemModel) {
            FramedTankItemModel tankModel = (FramedTankItemModel)model;
            model = tankModel.getBaseModel();
        } else {
            model = ErrorModel.get();
            validModel = false;
        }
        model = model.applyTransform(ctx, poseStack, ClientUtils.isLeftHand(ctx));
        poseStack.translate(-0.5, -0.5, -0.5);
        boolean glint = stack.hasFoil();
        for (BakedModel pass : model.getRenderPasses(stack, true)) {
            for (RenderType type : pass.getRenderTypes(stack, true)) {
                VertexConsumer consumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)type, (boolean)true, (boolean)glint);
                renderer.renderModelLists(pass, stack, light, overlay, poseStack, consumer);
            }
        }
        if (!validModel) {
            return;
        }
        Object camo = ((CamoList)stack.getOrDefault(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY)).getCamo(0).getContent();
        if (((CamoContent)camo).isSolid((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
            return;
        }
        SimpleFluidContent content = (SimpleFluidContent)stack.getOrDefault(FBContent.DC_TYPE_TANK_CONTENTS, (Object)SimpleFluidContent.EMPTY);
        if (content.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidExt = IClientFluidTypeExtensions.of((Fluid)content.getFluid());
        ResourceLocation stillTex = fluidExt.getStillTexture();
        ResourceLocation flowTex = fluidExt.getFlowingTexture();
        int tint = fluidExt.getTintColor();
        RenderType renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)content.getFluid().defaultFluidState());
        FramedTankRenderer.renderContents(poseStack, buffer, renderType, light, content.getAmount(), stillTex, flowTex, tint);
    }
}

