/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.client.screen.IFramingSawScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.PoweredFramingSawMenu;
import xfacthd.framedblocks.common.net.payload.ServerboundSelectFramingSawRecipePayload;

public class PoweredFramingSawScreen
extends AbstractContainerScreen<PoweredFramingSawMenu>
implements IFramingSawScreen {
    private static final ResourceLocation BACKGROUND = Utils.rl("textures/gui/powered_framing_saw.png");
    public static final Component TITLE_TARGETBLOCK = Utils.translate("title", "powered_saw.target_block");
    public static final MutableComponent MSG_STATUS = Utils.translate("msg", "powered_saw.status");
    public static final Component MSG_STATUS_NO_RECIPE = Utils.translate("msg", "powered_saw.status.no_recipe").withStyle(Style.EMPTY.withColor(0xDD7700));
    public static final Component MSG_STATUS_NO_MATCH = Utils.translate("msg", "powered_saw.status.no_match").withStyle(Style.EMPTY.withColor(0xDD0000));
    public static final Component MSG_STATUS_READY = Utils.translate("msg", "powered_saw.status.ready").withStyle(Style.EMPTY.withColor(56576));
    public static final Component TOOLTIP_STATUS_NO_RECIPE = Utils.translate("tooltip", "powered_saw.status.no_recipe");
    public static final String TOOLTIP_ENERGY = Utils.translationKey("tooltip", "powered_saw.energy");
    private static final int TITLE_TARGETBLOCK_X = 88;
    private static final int TITLE_TARGETBLOCK_Y = 24;
    private static final int TARGET_STACK_X = 92;
    private static final int TARGET_STACK_Y = 20;
    private static final int STATUS_X = 8;
    private static final int STATUS_Y = 62;
    private static final int ENERGY_X = 8;
    private static final int ENERGY_Y = 18;
    private static final int ENERGY_WIDTH = 14;
    private static final int ENERGY_HEIGHT = 48;
    private static final int ENERGY_U = 176;
    private static final int ENERGY_V = 16;
    public static final int PROGRESS_X = 115;
    public static final int PROGRESS_Y = 46;
    public static final int PROGRESS_WIDTH = 22;
    public static final int PROGRESS_HEIGHT = 16;
    private static final int PROGRESS_U = 176;
    private static final int PROGRESS_V = 0;
    private static final int CROSS_SIZE = 16;
    private static final int CROSS_U = 176;
    private static final int CROSS_V = 64;
    private static final Rect2i EMPTY = new Rect2i(0, 0, 0, 0);
    private final FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
    private final ItemStack cubeStack = new ItemStack((ItemLike)FBContent.BLOCK_FRAMED_CUBE.value());
    private int targetStackX;
    private int targetStackY;
    private Rect2i statusTooltipArea = EMPTY;
    private List<Component> statusTooltip = List.of();

    public PoweredFramingSawScreen(PoweredFramingSawMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.imageHeight = 182;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.targetStackX = this.leftPos + 92;
        this.targetStackY = this.topPos + 20;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int tx = this.leftPos + 88 - this.font.width((FormattedText)TITLE_TARGETBLOCK);
        int ty = this.topPos + 24;
        graphics.drawString(this.font, TITLE_TARGETBLOCK, tx, ty, 0x404040, false);
        RecipeHolder<FramingSawRecipe> recipe = ((PoweredFramingSawMenu)this.menu).getSelectedRecipe();
        if (recipe != null) {
            FramingSawRecipeMatchResult match = ((PoweredFramingSawMenu)this.menu).getMatchResult();
            this.drawRecipeInfo(graphics, (FramingSawRecipe)recipe.value(), match);
            this.drawStatus(graphics, (FramingSawRecipe)recipe.value(), match);
        }
        this.drawEnergyBar(graphics, mouseX, mouseY);
    }

    private void drawRecipeInfo(GuiGraphics graphics, FramingSawRecipe recipe, FramingSawRecipeMatchResult match) {
        Slot inputSlot = ((PoweredFramingSawMenu)this.menu).getSlot(0);
        if (!inputSlot.hasItem()) {
            int ix = this.leftPos + inputSlot.x;
            int iy = this.topPos + inputSlot.y;
            ClientUtils.renderTransparentFakeItem(graphics, this.cubeStack, ix, iy);
        }
        if (recipe != null) {
            float progress;
            ItemStack result = recipe.getResult();
            ClientUtils.renderTransparentFakeItem(graphics, result, this.targetStackX, this.targetStackY);
            List<FramingSawRecipeAdditive> additives = recipe.getAdditives();
            for (int i = 0; i < 3; ++i) {
                Slot additiveSlot = ((PoweredFramingSawMenu)this.menu).getSlot(1 + i);
                if (i >= additives.size()) {
                    int ax = this.leftPos + additiveSlot.x;
                    int ay = this.topPos + additiveSlot.y;
                    graphics.blit(BACKGROUND, ax, ay, 176, 64, 16, 16);
                    continue;
                }
                if (additiveSlot.hasItem()) continue;
                ItemStack[] items = additives.get(i).ingredient().getItems();
                int t = (int)(System.currentTimeMillis() / 1700L) % items.length;
                int ax = this.leftPos + additiveSlot.x;
                int ay = this.topPos + additiveSlot.y;
                ClientUtils.renderTransparentFakeItem(graphics, items[t], ax, ay);
            }
            if (match != null && match.success() && (progress = (float)((PoweredFramingSawMenu)this.menu).getProgress() / (float)((PoweredFramingSawMenu)this.menu).getCraftingDuration()) > 0.0f) {
                int width = Math.round(22.0f * progress);
                graphics.blit(BACKGROUND, this.leftPos + 115, this.topPos + 46, 176, 0, width, 16);
            }
        }
    }

    private void drawStatus(GuiGraphics graphics, FramingSawRecipe recipe, FramingSawRecipeMatchResult match) {
        Rect2i rect2i;
        MutableComponent status = MSG_STATUS.copy();
        int width = -1;
        if (recipe == null) {
            status = status.append(MSG_STATUS_NO_RECIPE);
            this.statusTooltip = List.of(TOOLTIP_STATUS_NO_RECIPE);
            width = this.font.width((FormattedText)MSG_STATUS_NO_RECIPE);
        } else if (match != null && !match.success()) {
            status = status.append(MSG_STATUS_NO_MATCH);
            this.statusTooltip = FramingSawScreen.appendRecipeFailure(new ArrayList<Component>(), this.cache, recipe, match, this);
            width = this.font.width((FormattedText)MSG_STATUS_NO_MATCH);
        } else {
            status = status.append(MSG_STATUS_READY);
        }
        int sx = this.leftPos + 8;
        Objects.requireNonNull(this.font);
        int sy = this.topPos + 62 + 9;
        graphics.drawString(this.font, (Component)status, sx, sy, 0x404040, false);
        if (width == -1) {
            rect2i = EMPTY;
        } else {
            int n = sx + this.font.width((FormattedText)MSG_STATUS);
            Objects.requireNonNull(this.font);
            rect2i = new Rect2i(n, sy, width, 9);
        }
        this.statusTooltipArea = rect2i;
    }

    private void drawEnergyBar(GuiGraphics graphics, int mouseX, int mouseY) {
        float energy = (float)((PoweredFramingSawMenu)this.menu).getEnergy() / (float)((PoweredFramingSawMenu)this.menu).getEnergyCapacity();
        int height = (int)(energy * 48.0f);
        int y = this.topPos + 18 + (48 - height);
        graphics.blit(BACKGROUND, this.leftPos + 8, y, 176, 16 + (48 - height), 14, height);
        int minX = this.leftPos + 8;
        int minY = this.topPos + 18;
        if (mouseX >= minX && mouseX < minX + 14 && mouseY >= minY && mouseY < minY + 48) {
            this.setTooltipForNextRenderPass((Component)Component.translatable((String)TOOLTIP_ENERGY, (Object[])new Object[]{((PoweredFramingSawMenu)this.menu).getEnergy(), ((PoweredFramingSawMenu)this.menu).getEnergyCapacity()}));
        }
    }

    @Override
    public ItemStack getInputStack() {
        return ((PoweredFramingSawMenu)this.menu).getInputStack();
    }

    @Override
    public ItemStack getAdditiveStack(int slot) {
        return ((PoweredFramingSawMenu)this.menu).getAdditiveStack(slot);
    }

    @Override
    public RecipeInput getRecipeInput() {
        return ((PoweredFramingSawMenu)this.menu).getRecipeInput();
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((PoweredFramingSawMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            this.renderHoveredItemTooltip(graphics, mouseX, mouseY, this.hoveredSlot.getItem());
            return;
        }
        if (this.statusTooltipArea.contains(mouseX, mouseY)) {
            graphics.renderTooltip(this.font, this.statusTooltip, Optional.empty(), ItemStack.EMPTY, mouseX, mouseY);
            this.statusTooltipArea = EMPTY;
            this.statusTooltip = List.of();
        }
    }

    private void renderHoveredItemTooltip(GuiGraphics graphics, int mouseX, int mouseY, ItemStack stack) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(PoweredFramingSawScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)stack));
        Optional tooltip = stack.getTooltipImage();
        int material = this.cache.getMaterialValue(stack.getItem());
        if (material > 0) {
            components.add(Component.translatable((String)FramingSawScreen.TOOLTIP_MATERIAL, (Object[])new Object[]{material}));
        }
        graphics.renderTooltip(this.font, components, tooltip, stack, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int btn) {
        if (mouseX >= (double)this.targetStackX && mouseX < (double)(this.targetStackX + 18) && mouseY >= (double)this.targetStackY && mouseY < (double)(this.targetStackY + 18)) {
            this.selectRecipe(((PoweredFramingSawMenu)this.menu).getCarried());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, btn);
    }

    public boolean isMouseOverRecipeSlot(double mouseX, double mouseY) {
        return mouseX >= (double)this.targetStackX && mouseX < (double)(this.targetStackX + 16) && mouseY >= (double)this.targetStackY && mouseY < (double)(this.targetStackY + 16);
    }

    public void selectRecipe(ItemStack cursorStack) {
        if (cursorStack.isEmpty() || this.cache.getMaterialValue(cursorStack.getItem()) != -1) {
            int id;
            RecipeHolder<FramingSawRecipe> recipe = this.cache.findRecipeFor(cursorStack);
            if (Objects.equals(recipe, ((PoweredFramingSawMenu)this.menu).getSelectedRecipe())) {
                return;
            }
            int n = id = recipe == null ? -1 : this.cache.getRecipes().indexOf(recipe);
            if (((PoweredFramingSawMenu)this.menu).clickMenuButton((Player)this.minecraft.player, id)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSelectFramingSawRecipePayload(((PoweredFramingSawMenu)this.menu).containerId, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public int getTargetStackX() {
        return this.targetStackX;
    }

    public int getTargetStackY() {
        return this.targetStackY;
    }

    public Rect2i getTargetStackArea() {
        return new Rect2i(this.targetStackX, this.targetStackY, this.targetStackX + 16, this.targetStackY + 16);
    }
}

