/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.compat.searchables.SearchablesCompat;

public final class SearchEditBox
extends EditBox {
    private static final long UPDATE_DELAY = 250L;
    private static final boolean NO_DELAY = SearchablesCompat.isLoaded();
    private final Consumer<String> searchHandler;
    private boolean changed = false;
    private String lastQuery = "";
    private long lastChange = 0L;

    public SearchEditBox(Font font, int x, int y, int w, int h, Component hint, Consumer<String> searchHandler, @Nullable SearchEditBox prev) {
        super(font, x, y, w, h, (EditBox)prev, hint);
        this.searchHandler = searchHandler;
        this.setHint(hint);
        this.setResponder(this::onSearchChanged);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int btn) {
        if (btn == 1 && this.clicked(mouseX, mouseY)) {
            this.setValue("");
            if (!NO_DELAY) {
                this.lastChange = System.currentTimeMillis() - 250L;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, btn);
    }

    private void onSearchChanged(String text) {
        if (this.lastQuery.equals(text)) {
            return;
        }
        if (NO_DELAY) {
            this.searchHandler.accept(text);
        } else {
            this.changed = true;
            this.lastChange = System.currentTimeMillis();
        }
        this.lastQuery = text;
    }

    public void tick() {
        if (!NO_DELAY && this.changed && System.currentTimeMillis() - this.lastChange > 250L) {
            this.changed = false;
            this.searchHandler.accept(this.lastQuery);
        }
    }

    public boolean isBordered() {
        return false;
    }

    public int getInnerWidth() {
        return this.width - 8;
    }
}

