/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive.button;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.model.wrapping.WrapHelper;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.interactive.button.FramedButtonBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLargeButtonBlock
extends FramedButtonBlock {
    public static final LargeButtonStateMerger LARGE_STATE_MERGER = new LargeButtonStateMerger();
    private static final VoxelShape SHAPE_BOTTOM = FramedLargeButtonBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape SHAPE_BOTTOM_PRESSED = FramedLargeButtonBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape SHAPE_TOP = FramedLargeButtonBlock.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_TOP_PRESSED = FramedLargeButtonBlock.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape[] SHAPES_HORIZONTAL = FramedLargeButtonBlock.makeHorizontalShapes();

    private FramedLargeButtonBlock(BlockType type, BlockSetType blockSet, int pressTime) {
        super(type, blockSet, pressTime);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FramedLargeButtonBlock.getShape(state);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return state.getValue((Property)FACE) != AttachFace.WALL;
    }

    public static VoxelShape getShape(BlockState state) {
        boolean pressed = (Boolean)state.getValue((Property)POWERED);
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> {
                if (pressed) {
                    yield SHAPE_BOTTOM_PRESSED;
                }
                yield SHAPE_BOTTOM;
            }
            case AttachFace.CEILING -> {
                if (pressed) {
                    yield SHAPE_TOP_PRESSED;
                }
                yield SHAPE_TOP;
            }
            case AttachFace.WALL -> {
                int idx = ((Direction)state.getValue((Property)FACING)).get2DDataValue() + (pressed ? 4 : 0);
                yield SHAPES_HORIZONTAL[idx];
            }
        };
    }

    private static VoxelShape[] makeHorizontalShapes() {
        VoxelShape shape = FramedLargeButtonBlock.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0);
        VoxelShape shapePressed = FramedLargeButtonBlock.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
        return ShapeUtils.makeHorizontalRotationsWithFlag(shape, shapePressed, Direction.SOUTH);
    }

    public static FramedLargeButtonBlock wood() {
        return new FramedLargeButtonBlock(BlockType.FRAMED_LARGE_BUTTON, BlockSetType.OAK, 30);
    }

    public static FramedLargeButtonBlock stone() {
        return new FramedLargeButtonBlock(BlockType.FRAMED_LARGE_STONE_BUTTON, BlockSetType.STONE, 20);
    }

    public static final class LargeButtonStateMerger
    implements StateMerger {
        private final StateMerger ignoringMerger = StateMerger.ignoring(WrapHelper.IGNORE_ALWAYS);

        private LargeButtonStateMerger() {
        }

        @Override
        public BlockState apply(BlockState state) {
            AttachFace face = (AttachFace)(state = this.ignoringMerger.apply(state)).getValue((Property)FACE);
            if (face != AttachFace.WALL) {
                state = (BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH);
            }
            return state;
        }

        @Override
        public Set<Property<?>> getHandledProperties(Holder<Block> block) {
            return Utils.concat(this.ignoringMerger.getHandledProperties(block), Set.of(FACING));
        }
    }
}

