/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;

public class FramedExtendedDoubleCornerSlopePanelBlockEntity
extends FramedDoubleBlockEntity {
    public FramedExtendedDoubleCornerSlopePanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Direction side = hit.getDirection();
        boolean top = (Boolean)this.getBlockState().getValue((Property)FramedProperties.TOP);
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return false;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR);
        if (side == facing.getOpposite() || side == facing.getClockWise()) {
            return true;
        }
        Vec3 hitVec = hit.getLocation();
        if (!top && side == Direction.UP || top && side == Direction.DOWN) {
            double xz1 = Utils.fractionInDir(hitVec, facing.getOpposite());
            double xz2 = Utils.fractionInDir(hitVec, facing.getClockWise());
            return xz1 > 0.5 || xz2 > 0.5;
        }
        double xz = Utils.fractionInDir(hitVec, side == facing ? facing.getClockWise() : facing.getOpposite());
        if (xz < 0.5) {
            return false;
        }
        double y = Utils.fractionInDir(hitVec, top ? Direction.UP : Direction.DOWN);
        return (xz - 0.5) * 2.0 > y;
    }
}

