/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;

public class FramedChiseledBookshelfBlockEntity
extends FramedBlockEntity {
    public static final String INVENTORY_NBT_KEY = "inventory";
    public static final String LAST_SLOT_NBT_KEY = "last_slot";
    private final ItemStackHandler itemHandler = new ItemStackHandler(6);
    private int lastInteractedSlot = -1;

    public FramedChiseledBookshelfBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_CHISELED_BOOKSHELF.value(), pos, state);
    }

    public void placeBook(ItemStack stack, int slot) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.updateState(slot);
        this.setChanged();
    }

    public ItemStack takeBook(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.EMPTY);
        this.updateState(slot);
        this.setChanged();
        return stack;
    }

    private void updateState(int slot) {
        this.lastInteractedSlot = slot;
        BlockState state = this.getBlockState();
        for (int i = 0; i < 6; ++i) {
            BooleanProperty prop = (BooleanProperty)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(i);
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(!this.itemHandler.getStackInSlot(i).isEmpty()));
        }
        this.level().setBlockAndUpdate(this.worldPosition, state);
    }

    public void forceStateUpdate() {
        this.updateState(this.lastInteractedSlot);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public void clearContents() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getAnalogOutputSignal() {
        return this.lastInteractedSlot + 1;
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put(INVENTORY_NBT_KEY, (Tag)this.itemHandler.serializeNBT(provider));
        nbt.putInt(LAST_SLOT_NBT_KEY, this.lastInteractedSlot);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.itemHandler.deserializeNBT(provider, nbt.getCompound(INVENTORY_NBT_KEY));
        this.lastInteractedSlot = nbt.getInt(LAST_SLOT_NBT_KEY);
    }
}

