/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedHopperBlockEntity
extends FramedBlockEntity
implements Hopper,
MenuProvider {
    public static final Component TITLE = Utils.translate("title", "framed_hopper");
    public static final String COOLDOWN_NBT_KEY = "TransferCooldown";
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private int cooldownTime = -1;
    private long tickedGameTime;
    private Direction facing;

    public FramedHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_HOPPER.value(), pos, state);
        this.facing = (Direction)state.getValue((Property)HopperBlock.FACING);
    }

    public static void tick(Level level, BlockPos ignoredPos, BlockState ignoredState, FramedHopperBlockEntity hopper) {
        --hopper.cooldownTime;
        hopper.tickedGameTime = level.getGameTime();
        if (!hopper.isOnCooldown()) {
            hopper.setCooldown(0);
            hopper.tryMoveItems(() -> HopperBlockEntity.suckInItems((Level)level, (Hopper)hopper));
        }
    }

    private void tryMoveItems(BooleanSupplier validator) {
        if (!this.level().isClientSide() && !this.isOnCooldown() && ((Boolean)this.getBlockState().getValue((Property)HopperBlock.ENABLED)).booleanValue()) {
            boolean success = false;
            if (!this.isEmpty()) {
                success = this.ejectItems();
            }
            if (!this.isFull()) {
                success |= validator.getAsBoolean();
            }
            if (success) {
                this.setCooldown(8);
                this.setChanged();
            }
        }
    }

    private boolean ejectItems() {
        BlockPos adjPos = this.worldPosition.relative(this.facing);
        Direction side = this.facing.getOpposite();
        IItemHandler itemHandler = (IItemHandler)this.level().getCapability(Capabilities.ItemHandler.BLOCK, adjPos, null, null, (Object)side);
        if (itemHandler != null && !FramedHopperBlockEntity.isFull(itemHandler)) {
            return this.ejectItemsInto(itemHandler, side, (src, dest, stack, destSide) -> ItemHandlerHelper.insertItem((IItemHandler)dest, (ItemStack)stack, (boolean)false));
        }
        Container container = HopperBlockEntity.getContainerAt((Level)this.level(), (BlockPos)adjPos);
        if (container != null && !HopperBlockEntity.isFullContainer((Container)container, (Direction)side)) {
            return this.ejectItemsInto(container, side, HopperBlockEntity::addItem);
        }
        return false;
    }

    private <T> boolean ejectItemsInto(T target, Direction side, InsertionFunction<T> inserter) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            int count = stack.getCount();
            ItemStack remainder = inserter.insert((Container)this, target, this.removeItem(i, 1), side);
            if (remainder.isEmpty()) {
                return true;
            }
            stack.setCount(count);
            if (count != 1) continue;
            this.setItem(i, stack);
        }
        return false;
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (!stack.isEmpty() && stack.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    public void setCooldown(int cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    public void entityInside(Entity entity) {
        AABB entityBounds;
        ItemEntity itemEntity;
        if (entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).getItem().isEmpty() && (entityBounds = entity.getBoundingBox().move((double)(-this.worldPosition.getX()), (double)(-this.worldPosition.getY()), (double)(-this.worldPosition.getZ()))).intersects(this.getSuckAabb())) {
            this.tryMoveItems(() -> HopperBlockEntity.addItem((Container)this, (ItemEntity)itemEntity));
        }
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }

    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    public boolean isGridAligned() {
        return true;
    }

    public void setItem(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.items, (int)slot);
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean isFull() {
        for (ItemStack stack : this.items) {
            if (!stack.isEmpty() && stack.getCount() >= stack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public void clearContent() {
        this.items.clear();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    @Override
    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.facing = (Direction)state.getValue((Property)HopperBlock.FACING);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.cooldownTime = tag.getInt(COOLDOWN_NBT_KEY);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt(COOLDOWN_NBT_KEY, this.cooldownTime);
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new HopperMenu(containerId, inventory, (Container)this);
    }

    public Component getDisplayName() {
        return TITLE;
    }

    @FunctionalInterface
    private static interface InsertionFunction<T> {
        public ItemStack insert(Container var1, T var2, ItemStack var3, Direction var4);
    }

    public final class ItemHandler
    extends InvWrapper {
        public ItemHandler() {
            super((Container)FramedHopperBlockEntity.this);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (simulate) {
                return super.insertItem(slot, stack, true);
            }
            boolean wasEmpty = this.getInv().isEmpty();
            int originalStackSize = stack.getCount();
            stack = super.insertItem(slot, stack, false);
            if (wasEmpty && originalStackSize > stack.getCount() && !FramedHopperBlockEntity.this.isOnCustomCooldown()) {
                FramedHopperBlockEntity.this.setCooldown(8);
            }
            return stack;
        }
    }
}

