/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.AuxBlueprintData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.component.TargetColor;

public class FramedTargetBlockEntity
extends FramedBlockEntity {
    public static final DyeColor DEFAULT_COLOR = DyeColor.RED;
    private DyeColor overlayColor = DEFAULT_COLOR;

    public FramedTargetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_TARGET.value(), pos, state);
    }

    public boolean setOverlayColor(DyeColor overlayColor) {
        if (this.overlayColor != overlayColor) {
            if (!this.level().isClientSide()) {
                this.overlayColor = overlayColor;
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                this.setChangedWithoutSignalUpdate();
            }
            return true;
        }
        return false;
    }

    public int getOverlayColor() {
        return this.overlayColor.getTextColor();
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("overlay_color", this.overlayColor.getId());
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        super.handleUpdateTag(nbt, provider);
        if (nbt.contains("overlay_color")) {
            this.overlayColor = DyeColor.byId((int)nbt.getInt("overlay_color"));
        }
    }

    @Override
    protected void writeToDataPacket(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(tag, lookupProvider);
        tag.putInt("overlay_color", this.overlayColor.getId());
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        DyeColor color;
        boolean colored = false;
        if (nbt.contains("overlay_color") && this.overlayColor != (color = DyeColor.byId((int)nbt.getInt("overlay_color")))) {
            this.overlayColor = color;
            colored = true;
        }
        return super.readFromDataPacket(nbt, lookupProvider) || colored;
    }

    @Override
    protected Optional<AuxBlueprintData<?>> collectAuxBlueprintData() {
        return Optional.of(new TargetColor(this.overlayColor));
    }

    @Override
    protected void applyAuxDataFromBlueprint(AuxBlueprintData<?> auxData) {
        if (auxData instanceof TargetColor) {
            TargetColor targetColor = (TargetColor)auxData;
            try {
                DyeColor dyeColor;
                DyeColor color;
                this.overlayColor = color = (dyeColor = targetColor.color());
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("overlay_color");
    }

    @Override
    protected void collectMiscComponents(DataComponentMap.Builder builder) {
        builder.set(FBContent.DC_TYPE_TARGET_COLOR, (Object)new TargetColor(this.overlayColor));
    }

    @Override
    protected void applyMiscComponents(BlockEntity.DataComponentInput input) {
        TargetColor color = (TargetColor)input.getOrDefault(FBContent.DC_TYPE_TARGET_COLOR, (Object)TargetColor.DEFAULT);
        this.overlayColor = color.color();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("overlay_color", this.overlayColor.getId());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("overlay_color")) {
            this.overlayColor = DyeColor.byId((int)tag.getInt("overlay_color"));
        }
    }
}

