/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jade;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import snownee.jade.api.ui.Element;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.common.compat.jade.SingleBlockFakeLevel;
import xfacthd.framedblocks.common.config.ClientConfig;

final class FramedBlockElement
extends Element {
    private static final float SIZE = 18.0f;
    private static final Vec2 SIZE_VEC = new Vec2(18.0f, 18.0f);
    private static final float Z_OFFSET = 15.0f;
    private static final float RENDER_SIZE = 16.0f;
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.2f, 1.0f, 0.7f).rotate((Quaternionfc)Quaternions.YP_180).normalize();
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(0.2f, 1.0f, 0.7f).rotate((Quaternionfc)Quaternions.YP_180).normalize();
    private static final ItemTransform DEFAULT_TRANSFORM = new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(), new Vector3f(0.625f, 0.625f, 0.625f));
    private static final RandomSource RANDOM = RandomSource.create();
    private final BlockState state;
    private final SingleBlockFakeLevel fakeLevel;
    private final BakedModel model;
    private final ModelData modelData;
    private final float scale;
    private final boolean useModelTransform;

    FramedBlockElement(BlockState state, FramedBlockEntity blockEntity) {
        IFramedBlock block = (IFramedBlock)state.getBlock();
        this.state = block.getJadeRenderState(state);
        this.fakeLevel = new SingleBlockFakeLevel(blockEntity.getBlockPos(), this.state, blockEntity);
        this.model = Minecraft.getInstance().getBlockRenderer().getBlockModel(this.state);
        boolean renderCamo = ClientConfig.VIEW.shouldRenderCamoInJade();
        this.modelData = renderCamo ? blockEntity.getModelData(false) : ModelData.EMPTY;
        this.scale = block.getJadeRenderScale(this.state);
        this.useModelTransform = block.shouldApplyGuiTransformFromModel();
    }

    public Vec2 getSize() {
        return SIZE_VEC;
    }

    public void render(GuiGraphics graphics, float x, float y, float maxX, float maxY) {
        if (!this.state.isAir()) {
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            poseStack.translate(x + 9.0f, y + 9.0f, 15.0f);
            poseStack.scale(16.0f * this.scale, -16.0f * this.scale, 16.0f * this.scale);
            if (this.useModelTransform) {
                this.model.applyTransform(ItemDisplayContext.GUI, poseStack, false);
            } else {
                DEFAULT_TRANSFORM.apply(false, poseStack);
            }
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            long seed = this.state.getSeed(BlockPos.ZERO);
            RANDOM.setSeed(seed);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            for (RenderType renderType : this.model.getRenderTypes(this.state, RANDOM, this.modelData)) {
                VertexConsumer consumer = buffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)true));
                Minecraft.getInstance().getBlockRenderer().getModelRenderer().tesselateBlock((BlockAndTintGetter)this.fakeLevel, this.model, this.state, BlockPos.ZERO, poseStack, consumer, false, RANDOM, seed, OverlayTexture.NO_OVERLAY, this.modelData, renderType);
            }
            RenderSystem.setupGuiFlatDiffuseLighting((Vector3f)DIFFUSE_LIGHT_0, (Vector3f)DIFFUSE_LIGHT_1);
            buffer.endBatch();
            Lighting.setupFor3DItems();
            poseStack.popPose();
        }
    }

    @Nullable
    public String getMessage() {
        return this.state.isAir() ? null : this.state.getBlock().getDescriptionId();
    }
}

