/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jade;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public record SingleBlockFakeLevel(BlockPos realPos, BlockState state, BlockEntity blockEntity) implements BlockAndTintGetter
{
    public float getShade(Direction side, boolean shade) {
        return this.blockEntity.getLevel().getShade(side, shade);
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return this.blockEntity.getLevel().getShade(normalX, normalY, normalZ, shade);
    }

    public LevelLightEngine getLightEngine() {
        return this.blockEntity.getLevel().getLightEngine();
    }

    public int getBrightness(LightLayer layer, BlockPos pos) {
        return 15;
    }

    public int getBlockTint(BlockPos pos, ColorResolver resolver) {
        return this.blockEntity.getLevel().getBlockTint(this.realPos, resolver);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        if (pos == BlockPos.ZERO) {
            return this.blockEntity;
        }
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        if (pos == BlockPos.ZERO) {
            return this.state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public FluidState getFluidState(BlockPos pos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public int getHeight() {
        return this.blockEntity.getLevel().getHeight();
    }

    public int getMinBuildHeight() {
        return this.blockEntity.getLevel().getMinBuildHeight();
    }
}

