/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.property;

import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;

public enum CornerType implements StringRepresentable
{
    BOTTOM,
    TOP,
    HORIZONTAL_BOTTOM_LEFT,
    HORIZONTAL_BOTTOM_RIGHT,
    HORIZONTAL_TOP_LEFT,
    HORIZONTAL_TOP_RIGHT;

    private final String name = this.toString().toLowerCase(Locale.ENGLISH);

    public String getSerializedName() {
        return this.name;
    }

    public boolean isHorizontal() {
        return this != BOTTOM && this != TOP;
    }

    public boolean isTop() {
        return this == TOP || this == HORIZONTAL_TOP_LEFT || this == HORIZONTAL_TOP_RIGHT;
    }

    public boolean isRight() {
        return this == HORIZONTAL_BOTTOM_RIGHT || this == HORIZONTAL_TOP_RIGHT;
    }

    public CornerType verticalOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> BOTTOM;
            case 0 -> TOP;
            case 3 -> HORIZONTAL_TOP_RIGHT;
            case 2 -> HORIZONTAL_TOP_LEFT;
            case 5 -> HORIZONTAL_BOTTOM_RIGHT;
            case 4 -> HORIZONTAL_BOTTOM_LEFT;
        };
    }

    public CornerType horizontalOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> this;
            case 3 -> HORIZONTAL_BOTTOM_LEFT;
            case 2 -> HORIZONTAL_BOTTOM_RIGHT;
            case 5 -> HORIZONTAL_TOP_LEFT;
            case 4 -> HORIZONTAL_TOP_RIGHT;
        };
    }

    public CornerType rotate(Rotation rot) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 4 -> {
                switch (rot) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NONE: {
                        yield this;
                    }
                    case CLOCKWISE_90: {
                        yield HORIZONTAL_TOP_RIGHT;
                    }
                    case CLOCKWISE_180: {
                        yield HORIZONTAL_BOTTOM_RIGHT;
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                yield HORIZONTAL_BOTTOM_LEFT;
            }
            case 5 -> {
                switch (rot) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NONE: {
                        yield this;
                    }
                    case CLOCKWISE_90: {
                        yield HORIZONTAL_BOTTOM_RIGHT;
                    }
                    case CLOCKWISE_180: {
                        yield HORIZONTAL_BOTTOM_LEFT;
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                yield HORIZONTAL_TOP_LEFT;
            }
            case 2 -> {
                switch (rot) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NONE: {
                        yield this;
                    }
                    case CLOCKWISE_90: {
                        yield HORIZONTAL_TOP_LEFT;
                    }
                    case CLOCKWISE_180: {
                        yield HORIZONTAL_TOP_RIGHT;
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                yield HORIZONTAL_BOTTOM_RIGHT;
            }
            case 3 -> {
                switch (rot) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NONE: {
                        yield this;
                    }
                    case CLOCKWISE_90: {
                        yield HORIZONTAL_BOTTOM_LEFT;
                    }
                    case CLOCKWISE_180: {
                        yield HORIZONTAL_TOP_LEFT;
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                yield HORIZONTAL_TOP_RIGHT;
            }
            case 0, 1 -> throw new IllegalStateException("Non-horizontal CornerTypes cannot be rotated");
        };
    }

    public boolean isHorizontalAdjacent(Direction dir, Direction side, CornerType adjType) {
        if (!this.isHorizontal() || !adjType.isHorizontal()) {
            return false;
        }
        switch (this.ordinal()) {
            case 4: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                if (side == dir.getCounterClockWise()) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                return false;
            }
            case 5: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                if (side == dir.getClockWise()) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                return false;
            }
            case 2: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                if (side == dir.getCounterClockWise()) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                return false;
            }
            case 3: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                if (side == dir.getClockWise()) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                return false;
            }
        }
        return false;
    }

    public boolean isHorizontalAdjacentInner(Direction dir, Direction side, CornerType adjType) {
        if (!this.isHorizontal() || !adjType.isHorizontal()) {
            return false;
        }
        switch (this.ordinal()) {
            case 3: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                if (side == dir.getCounterClockWise()) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                return false;
            }
            case 2: {
                if (side == Direction.UP) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                if (side == dir.getClockWise()) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                return false;
            }
            case 5: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_BOTTOM_RIGHT;
                }
                if (side == dir.getCounterClockWise()) {
                    return adjType == HORIZONTAL_TOP_LEFT;
                }
                return false;
            }
            case 4: {
                if (side == Direction.DOWN) {
                    return adjType == HORIZONTAL_BOTTOM_LEFT;
                }
                if (side == dir.getClockWise()) {
                    return adjType == HORIZONTAL_TOP_RIGHT;
                }
                return false;
            }
        }
        return false;
    }
}

