/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;

public final class SlopeShapes
implements SplitShapeGenerator {
    public static final SlopeShapes INSTANCE = new SlopeShapes();
    public static final ShapeCache<SlopeType> SHAPES = SlopeShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0)));
    public static final ShapeCache<SlopeType> OCCLUSION_SHAPES = SlopeShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), Block.box((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)15.5), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), Block.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5)));
    private static final ShapeCache<ShapeKey> FINAL_SHAPES = ShapeCache.create(map -> {
        for (SlopeType type : SlopeType.values()) {
            ShapeUtils.makeHorizontalRotations(SHAPES.get(type), Direction.NORTH, map, type, ShapeKey::new);
        }
    });
    private static final ShapeCache<ShapeKey> FINAL_OCCLUSION_SHAPES = ShapeCache.create(map -> {
        for (SlopeType type : SlopeType.values()) {
            ShapeUtils.makeHorizontalRotations(OCCLUSION_SHAPES.get(type), Direction.NORTH, map, type, ShapeKey::new);
        }
    });

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return SlopeShapes.generate(states, FINAL_SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return SlopeShapes.generate(states, FINAL_OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> shapes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            ISlopeBlock block = (ISlopeBlock)state.getBlock();
            SlopeType type = block.getSlopeType(state);
            Direction dir = block.getFacing(state);
            builder.put((Object)state, (Object)shapes.get(new ShapeKey(dir, type)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<SlopeType> makeCache(Supplier<VoxelShape> bottomShapeFactory) {
        return ShapeCache.createEnum(SlopeType.class, map -> {
            VoxelShape bottomShape = (VoxelShape)bottomShapeFactory.get();
            map.put(SlopeType.BOTTOM, bottomShape);
            map.put(SlopeType.TOP, ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.DOWN, Direction.UP, bottomShape));
            map.put(SlopeType.HORIZONTAL, ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.DOWN, Direction.WEST, bottomShape));
        });
    }

    private record ShapeKey(Direction dir, SlopeType type) {
    }
}

