/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;

@CullTest(value={BlockType.FRAMED_LATTICE_BLOCK})
public final class LatticeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        boolean zAxis;
        boolean yAxis;
        boolean xAxis = (Boolean)state.getValue((Property)FramedProperties.X_AXIS);
        if (PillarDirs.Lattice.testEarlyExit(xAxis, yAxis = ((Boolean)state.getValue((Property)FramedProperties.Y_AXIS)).booleanValue(), zAxis = ((Boolean)state.getValue((Property)FramedProperties.Z_AXIS)).booleanValue(), side)) {
            return false;
        }
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            return switch (blockType) {
                case BlockType.FRAMED_LATTICE_BLOCK -> LatticeSkipPredicate.testAgainstLattice(xAxis, yAxis, zAxis, adjState, side);
                case BlockType.FRAMED_FENCE -> LatticeSkipPredicate.testAgainstFence(xAxis, yAxis, zAxis, side);
                case BlockType.FRAMED_POST -> LatticeSkipPredicate.testAgainstPost(xAxis, yAxis, zAxis, adjState, side);
                case BlockType.FRAMED_PYRAMID -> LatticeSkipPredicate.testAgainstPyramid(xAxis, yAxis, zAxis, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> LatticeSkipPredicate.testAgainstElevatedPyramidSlab(xAxis, yAxis, zAxis, adjState, side);
                case BlockType.FRAMED_UPPER_PYRAMID_SLAB -> LatticeSkipPredicate.testAgainstUpperPyramidSlab(xAxis, yAxis, zAxis, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LATTICE_BLOCK})
    private static boolean testAgainstLattice(boolean xAxis, boolean yAxis, boolean zAxis, BlockState adjState, Direction side) {
        boolean adjXAxis = (Boolean)adjState.getValue((Property)FramedProperties.X_AXIS);
        boolean adjYAxis = (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS);
        boolean adjZAxis = (Boolean)adjState.getValue((Property)FramedProperties.Z_AXIS);
        return PillarDirs.Lattice.isPostDir(xAxis, yAxis, zAxis, side) && PillarDirs.Lattice.isPostDir(adjXAxis, adjYAxis, adjZAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE})
    private static boolean testAgainstFence(boolean xAxis, boolean yAxis, boolean zAxis, Direction side) {
        return PillarDirs.Lattice.isPostDir(xAxis, yAxis, zAxis, side) && PillarDirs.Fence.isPostDir(side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_POST})
    private static boolean testAgainstPost(boolean xAxis, boolean yAxis, boolean zAxis, BlockState adjState, Direction side) {
        Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
        return PillarDirs.Lattice.isPostDir(xAxis, yAxis, zAxis, side) && PillarDirs.Post.isPostDir(adjAxis, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PYRAMID})
    private static boolean testAgainstPyramid(boolean xAxis, boolean yAxis, boolean zAxis, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Lattice.isPostDir(xAxis, yAxis, zAxis, side) && SlopeDirs.Pyramid.isPostDir(adjDir, adjConnection, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(boolean xAxis, boolean yAxis, boolean zAxis, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Lattice.isPostDir(xAxis, yAxis, zAxis, side) && SlopeDirs.ElevatedPyramidSlab.isPostDir(adjDir, adjConnection, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_UPPER_PYRAMID_SLAB})
    private static boolean testAgainstUpperPyramidSlab(boolean xAxis, boolean yAxis, boolean zAxis, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        PillarConnection adjConnection = (PillarConnection)((Object)adjState.getValue(PropertyHolder.PILLAR_CONNECTION));
        return PillarDirs.Lattice.isPostDir(xAxis, yAxis, zAxis, side) && SlopeDirs.UpperPyramidSlab.isPostDir(adjDir, adjConnection, side.getOpposite());
    }
}

