/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.component.FramedMap;

@Mixin(value={MapItemSavedData.class})
public abstract class MixinMapItemSavedData
implements FramedMap.MarkerRemover {
    @Unique
    private final Map<String, FramedMap> framedblocks$frameMarkers = new HashMap<String, FramedMap>();
    @Shadow
    @Final
    private boolean trackingPosition;

    @Shadow
    protected abstract void addDecoration(Holder<MapDecorationType> var1, @Nullable LevelAccessor var2, String var3, double var4, double var6, double var8, @Nullable Component var10);

    @Shadow
    protected abstract void removeDecoration(String var1);

    @ModifyExpressionValue(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isFramed()Z", ordinal=0)})
    private boolean framedblocks$checkVanillaFramedOrCustomFramed(boolean isFramed, Player player, ItemStack stack) {
        return isFramed || stack.get(FBContent.DC_TYPE_FRAMED_MAP) != null;
    }

    @ModifyExpressionValue(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isFramed()Z", ordinal=1)})
    private boolean framedblocks$checkNotVanillaFramedAndNotCustomFramed(boolean isFramed, Player player, ItemStack stack) {
        return isFramed || stack.get(FBContent.DC_TYPE_FRAMED_MAP) != null;
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getOrDefault(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;")})
    private void framedblocks$updateFramedItemFrameMarker(Player player, ItemStack mapStack, CallbackInfo ci) {
        String frameId;
        FramedMap framedMap;
        if (this.trackingPosition && (framedMap = (FramedMap)mapStack.get(FBContent.DC_TYPE_FRAMED_MAP)) != null && !this.framedblocks$frameMarkers.containsKey(frameId = FramedMap.makeFrameId(framedMap.pos()))) {
            this.framedblocks$addMapMarker((LevelAccessor)player.level(), frameId, framedMap);
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private static void framedblocks$loadCustomMapMarkers(CompoundTag tag, HolderLookup.Provider lookupProvider, CallbackInfoReturnable<MapItemSavedData> cir) {
        ListTag frames = tag.getList("framedblocks:frames", 10);
        for (int i = 0; i < frames.size(); ++i) {
            CompoundTag frameTag = frames.getCompound(i);
            FramedMap.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)frameTag).ifSuccess(pair -> {
                FramedMap map = (FramedMap)pair.getFirst();
                String frameId = FramedMap.makeFrameId(map.pos());
                ((MixinMapItemSavedData)cir.getReturnValue()).framedblocks$addMapMarker(null, frameId, map);
            });
        }
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    private void framedblocks$saveCustomMapMarkers(CompoundTag tag, HolderLookup.Provider lookupProvider, CallbackInfoReturnable<CompoundTag> cir) {
        if (!this.framedblocks$frameMarkers.isEmpty()) {
            ListTag frames = new ListTag();
            for (FramedMap map : this.framedblocks$frameMarkers.values()) {
                FramedMap.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)map).ifSuccess(arg_0 -> frames.add(arg_0));
            }
            tag.put("framedblocks:frames", (Tag)frames);
        }
    }

    @Override
    public void framedblocks$removeMapMarker(BlockPos pos) {
        String frameId = FramedMap.makeFrameId(pos);
        this.removeDecoration(frameId);
        this.framedblocks$frameMarkers.remove(frameId);
    }

    @Unique
    private void framedblocks$addMapMarker(LevelAccessor level, String frameId, FramedMap framedMap) {
        BlockPos pos = framedMap.pos();
        int rot = framedMap.yRot();
        this.addDecoration((Holder<MapDecorationType>)MapDecorationTypes.FRAME, level, frameId, pos.getX(), pos.getZ(), rot, null);
        this.framedblocks$frameMarkers.put(frameId, framedMap);
    }
}

