/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.item;

import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistries;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistry;
import com.cerbon.myths_of_the_sea.entity.MTSEntities;
import com.cerbon.myths_of_the_sea.item.custom.LeviathanHeartItem;
import com.cerbon.myths_of_the_sea.item.custom.MTSSpawnEggItem;
import com.cerbon.myths_of_the_sea.item.custom.armor.MTSArmorMaterials;
import com.cerbon.myths_of_the_sea.platform.Services;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;

public final class MTSItems {
    public static final ResourcefulRegistry<Item> ITEMS = ResourcefulRegistries.create((Registry)BuiltInRegistries.f_257033_, (String)"myths_of_the_sea");
    public static final TagKey<Item> HIPPOCAMPUS_FOOD = MTSItems.bind("hippocampus_food");
    public static final TagKey<Item> HIPPOCAMPUS_FOOD_MATING = MTSItems.bind("hippocampus_food_mating");
    public static final RegistryEntry<Item> BAKE_KUJIRA_BONE = MTSItems.registerItem("bake_kujira_bone");
    public static final RegistryEntry<Item> BUNYIP_FANG = MTSItems.registerItem("bunyip_fang");
    public static final RegistryEntry<Item> HIPPOCAMPUS_EYE = MTSItems.registerItem("hippocampus_eye");
    public static final RegistryEntry<Item> ABAIA_FIN = MTSItems.registerItem("abaia_fin");
    public static final RegistryEntry<Item> KRAKEN_TENTACLE = MTSItems.registerItem(Services.PLATFORM.krakenTentacleItem(new Item.Properties().m_41487_(1)), "kraken_tentacle");
    public static final RegistryEntry<Item> BUNYIP_CLAW = MTSItems.registerItem(Services.PLATFORM.bunyipClawItem(4.0f, -2.4f, new Item.Properties().m_41503_(250)), "bunyip_claw");
    public static final RegistryEntry<Item> ABAIA_TAIL_BOOTS = MTSItems.registerItem(Services.PLATFORM.abaiaTailItem(new Item.Properties().m_41503_(250)), "abaia_tail_boots");
    public static final RegistryEntry<Item> LEVIATHAN_HEART = MTSItems.registerItem(() -> new LeviathanHeartItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(4).m_38758_(1.2f).m_38767_())), "leviathan_heart");
    public static final Map<ArmorItem.Type, RegistryEntry<ArmorItem>> BAKE_KUJIRA_ARMOR_SET = MTSItems.registerFullArmorSet(MTSArmorMaterials.BAKE_KUJIRA);
    public static final RegistryEntry<SpawnEggItem> ABAIA_SPAWN_EGG = MTSItems.registerEgg(MTSEntities.ABAIA, 5468777, 7443594, MTSEntities.ABAIA.getId().m_135815_());
    public static final RegistryEntry<SpawnEggItem> BAKE_KUJIRA_SPAWN_EGG = MTSItems.registerEgg(MTSEntities.BAKE_KUJIRA, 15392970, 16051679, MTSEntities.BAKE_KUJIRA.getId().m_135815_());
    public static final RegistryEntry<SpawnEggItem> BUNYIP_SPAWN_EGG = MTSItems.registerEgg(MTSEntities.BUNYIP, 8278330, 9792857, MTSEntities.BUNYIP.getId().m_135815_());
    public static final RegistryEntry<SpawnEggItem> LEVIATHAN_SPAWN_EGG = MTSItems.registerEgg(MTSEntities.LEVIATHAN, 5598326, 6782599, MTSEntities.LEVIATHAN.getId().m_135815_());
    public static final RegistryEntry<SpawnEggItem> HIPPOCAMPUS_SPAWN_EGG = MTSItems.registerEgg(MTSEntities.HIPPOCAMPUS, 4173261, 14666351, MTSEntities.HIPPOCAMPUS.getId().m_135815_());
    public static final RegistryEntry<SpawnEggItem> KRAKEN_SPAWN_EGG = MTSItems.registerEgg(MTSEntities.KRAKEN, 5993576, 7176824, MTSEntities.KRAKEN.getId().m_135815_());

    private static Map<ArmorItem.Type, RegistryEntry<ArmorItem>> registerFullArmorSet(ArmorMaterial material) {
        return MTSItems.registerFullArmorSet(material, properties -> properties);
    }

    private static Map<ArmorItem.Type, RegistryEntry<ArmorItem>> registerFullArmorSet(ArmorMaterial material, UnaryOperator<Item.Properties> itemProperties) {
        return ImmutableMap.of((Object)ArmorItem.Type.HELMET, MTSItems.registerArmor(ArmorItem.Type.HELMET, material, itemProperties), (Object)ArmorItem.Type.CHESTPLATE, MTSItems.registerArmor(ArmorItem.Type.CHESTPLATE, material, itemProperties), (Object)ArmorItem.Type.LEGGINGS, MTSItems.registerArmor(ArmorItem.Type.LEGGINGS, material, itemProperties), (Object)ArmorItem.Type.BOOTS, MTSItems.registerArmor(ArmorItem.Type.BOOTS, material, itemProperties));
    }

    private static RegistryEntry<ArmorItem> registerArmor(ArmorItem.Type armorType, ArmorMaterial material, UnaryOperator<Item.Properties> itemProperties) {
        String materialName = material.m_6082_().split(":")[1];
        return MTSItems.registerItem(() -> new ArmorItem(material, armorType, (Item.Properties)itemProperties.apply(new Item.Properties())), materialName + "_" + armorType.m_266355_());
    }

    public static <T extends Mob> RegistryEntry<SpawnEggItem> registerEgg(Supplier<EntityType<T>> entityType, int backgroundColor, int highlightColor, String id) {
        return MTSItems.registerItem(() -> new MTSSpawnEggItem(entityType, backgroundColor, highlightColor, new Item.Properties()), id + "_spawn_egg");
    }

    private static RegistryEntry<Item> registerItem(String id) {
        return MTSItems.registerItem(new Item.Properties(), id);
    }

    private static RegistryEntry<Item> registerItem(Item.Properties itemProperties, String id) {
        return MTSItems.registerItem(() -> new Item(itemProperties), id);
    }

    private static <T extends Item> RegistryEntry<T> registerItem(Supplier<T> item, String id) {
        return ITEMS.register(id, item);
    }

    public static void register() {
        ITEMS.register();
    }

    private static TagKey<Item> bind(String name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("myths_of_the_sea", name));
    }
}

