/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.hippocampus;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.myths_of_the_sea.entity.MTSEntities;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.AbstractWaterHorse;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.goals.PlayWithItemsGoal;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.goals.TemptGoalNoMounted;
import com.cerbon.myths_of_the_sea.entity.custom.hippocampus.goals.TemptGoalTamed;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import com.cerbon.myths_of_the_sea.util.GeoControllersUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1346;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1393;
import net.minecraft.class_1399;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1577;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HippocampusEntity
extends AbstractWaterHorse
implements GeoEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HippocampusEntity(class_1299<? extends AbstractWaterHorse> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5952(true);
        this.method_49477(0.6f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1393((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0, HippocampusEntity.class));
        this.field_6201.method_6277(3, (class_1352)new TemptGoalNoMounted((class_1314)this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8429, class_1802.field_8209, class_1802.field_8846}), false));
        this.field_6201.method_6277(3, (class_1352)new TemptGoalTamed(this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8373, class_1802.field_8509}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1378((class_1314)this, 1.0, 10));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new PlayWithItemsGoal((class_1308)this));
        this.field_6201.method_6277(8, (class_1352)new class_1346((class_1314)this));
        this.field_6201.method_6277(9, (class_1352)new class_1338((class_1314)this, class_1577.class, 8.0f, 1.0, 1.0));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_1577.class}).method_6318(new Class[0]));
    }

    public boolean method_6034() {
        return super.method_6034() && !this.method_29504();
    }

    public static class_5132 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 45.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23718, 0.2).method_26868(class_5134.field_23719, 1.0).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23728, 0.0).method_26866();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, state -> GeoControllersUtil.commonMoveController(state, (class_1308)this))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Die", 0, state -> GeoControllersUtil.commonWaterAnimalDie(state, (class_1308)this))});
    }

    protected void method_6108() {
        CapabilityUtils.getLevelEventScheduler((class_1937)this.method_37908()).addEvent((IEvent)new TimedEvent(() -> super.method_6108(), 40));
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)MTSSounds.HIPPOCAMPUS_IDLE.get();
    }

    protected void method_5712(@NotNull class_2338 pos, @NotNull class_2680 state) {
    }

    @NotNull
    protected class_3414 method_5737() {
        return (class_3414)MTSSounds.HIPPOCAMPUS_MOVEMENT.get();
    }

    protected void method_5734(float volume) {
        float f = (float)this.method_18798().method_37267();
        if (f >= 0.01f) {
            super.method_5734(class_3532.method_16439((float)class_3532.method_15363((float)f, (float)0.0f, (float)0.5f), (float)0.0f, (float)1.2f));
        }
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return (class_3414)MTSSounds.HIPPOCAMPUS_DAMAGE.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)MTSSounds.HIPPOCAMPUS_DEATH.get();
    }

    public class_3414 getFlopSound() {
        return (class_3414)MTSSounds.HIPPOCAMPUS_FLOP.get();
    }

    @Nullable
    protected class_3414 method_28368() {
        return (class_3414)MTSSounds.HIPPOCAMPUS_EAT.get();
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_6034() && this.method_5799() && !this.method_42148()) {
            this.method_5724(this.method_6029(), travelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else if (this.method_5799() && this.method_42148()) {
            this.method_18799(this.method_18798().method_1021(0.9));
            super.method_6091(travelVector);
        } else {
            super.method_6091(travelVector);
        }
    }

    protected void method_6726(@NotNull class_1657 player) {
        this.method_36457(0.0f);
        if (!this.method_37908().field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
    }

    protected void method_49481(@NotNull class_1657 player, @NotNull class_243 travelVector) {
        class_241 vec2 = this.method_49489((class_1309)player);
        this.method_5710(vec2.field_1342, vec2.field_1343);
        this.field_6283 = this.field_6241 = this.method_36454();
        if (this.method_5787()) {
            this.controlHippocampus(travelVector);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void controlHippocampus(class_243 travelVector) {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 rider = (class_1657)class_13092;
            if (travelVector.field_1350 > 0.0) {
                float pitch = rider.method_36455();
                float yaw = rider.method_36454();
                float fYaw = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
                float fPitchY = -class_3532.method_15374((float)(pitch * ((float)Math.PI / 180)));
                float fYawCos = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
                float fPitchCos = class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
                double speed = this.method_5799() ? 0.8 : 0.001;
                class_243 direction = new class_243((double)(fYaw * fPitchCos), (double)fPitchY, (double)(fYawCos * fPitchCos)).method_1029().method_1021(speed);
                if (!this.method_5799()) {
                    direction = new class_243(direction.field_1352, this.method_18798().field_1351 - 0.05, direction.field_1350);
                }
                this.method_18799(direction);
                return;
            }
        }
        if (!this.method_5799()) {
            class_243 motion = this.method_18798();
            this.method_18800(motion.field_1352, motion.field_1351 - 0.05, motion.field_1350);
            return;
        }
        this.method_18799(class_243.field_1353);
    }

    public boolean method_6153() {
        return false;
    }

    @NotNull
    protected class_243 method_49482(@NotNull class_1657 player, @NotNull class_243 travelVector) {
        if (this.method_5799() || this.method_24828()) {
            float f = player.field_6212 * 0.5f;
            float g = player.field_6250;
            if (g <= 0.0f) {
                g *= 0.25f;
            }
            return new class_243((double)f, 0.0, (double)g);
        }
        return class_243.field_1353;
    }

    protected float method_49485(@NotNull class_1657 player) {
        return this.method_5799() ? (float)this.method_26825(class_5134.field_23719) : 0.1f;
    }

    public double method_5621() {
        return (double)this.method_18377((class_4050)this.method_18376()).field_18068 * 0.6;
    }

    protected void method_5865(@NotNull class_1297 passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        float yawRad = this.field_6283 * ((float)Math.PI / 180);
        float sinYaw = class_3532.method_15374((float)yawRad);
        float cosYaw = class_3532.method_15362((float)yawRad);
        float pitchRad = this.method_36455() * ((float)Math.PI / 180);
        float pitchOffset = (float)class_3532.method_15350((double)(class_3532.method_15374((float)pitchRad) * 1.2f), (double)-0.9, (double)1.0);
        double verticalPitchOffset = class_3532.method_15350((double)((double)class_3532.method_15374((float)pitchRad) * 1.0), (double)-0.6, (double)-0.4);
        double offsetX = -sinYaw * pitchOffset;
        double offsetZ = cosYaw * pitchOffset;
        callback.accept(passenger, this.method_23317() + (double)sinYaw * (verticalPitchOffset <= -0.5 ? 0.3 : 0.4) + offsetX, this.method_23318() + this.method_5621() + passenger.method_5678() + verticalPitchOffset + (verticalPitchOffset < 1.0 && verticalPitchOffset > -1.0 ? 0.15 : 0.0), this.method_23321() - (double)cosYaw * (verticalPitchOffset <= -0.5 ? 0.3 : 0.4) + offsetZ);
        if (passenger instanceof class_1309) {
            ((class_1309)passenger).field_6283 = this.field_6283;
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5987()) {
            this.method_5855(this.method_5748());
        }
        if (this.method_24828() && !this.method_5799() && !this.method_29504() && !this.method_5782()) {
            this.method_18799(this.method_18798().method_1031((double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.2f)));
            this.method_36456(this.field_5974.method_43057() * 360.0f);
            this.method_24830(false);
            this.field_6007 = true;
            this.method_5783(this.getFlopSound(), this.method_6107(), this.method_6017());
        }
    }

    public void method_6722(@NotNull class_1657 player) {
        if (!this.method_37908().field_9236) {
            player.method_7291((class_1496)this, (class_1263)this.field_6962);
        }
    }

    @NotNull
    protected class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() * 0.6, 0.0);
    }

    public int method_5748() {
        return 400;
    }

    protected float method_18394(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.75f;
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (this.method_5782()) {
            return super.method_5992(player, hand);
        }
        if (this.method_6481(stackInHand) || this.isMatingFood(stackInHand)) {
            return this.method_30009(player, stackInHand);
        }
        if (this.method_6727() && player.method_21823()) {
            this.method_6722(player);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_6727()) {
            class_1269 interactionResult;
            if (!stackInHand.method_7960() && (interactionResult = stackInHand.method_7920(player, (class_1309)this, hand)).method_23665()) {
                return interactionResult;
            }
            this.method_6726(player);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    @Nullable
    public HippocampusEntity getBreedOffspring(@NotNull class_3218 level, @NotNull class_1296 otherParent) {
        return (HippocampusEntity)((class_1299)MTSEntities.HIPPOCAMPUS.get()).method_5883((class_1937)level);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(MTSItems.HIPPOCAMPUS_FOOD);
    }

    private boolean isMatingFood(class_1799 stack) {
        return stack.method_31573(MTSItems.HIPPOCAMPUS_FOOD_MATING);
    }

    protected boolean method_6742(@NotNull class_1657 player, @NotNull class_1799 stack) {
        if (this.method_6481(stack) || this.isMatingFood(stack)) {
            if (!(this.method_6727() || this.isMatingFood(stack) || this.method_6109())) {
                if (this.field_5974.method_43048(5) == 0) {
                    this.method_6752(player);
                    this.field_6189.method_6340();
                    this.method_5980(null);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                }
                return this.playEatingSound();
            }
            if (this.method_6727()) {
                if (this.method_6032() < this.method_6063()) {
                    this.method_6025(stack.method_7909().method_19264() != null ? (float)stack.method_7909().method_19264().method_19230() : 1.0f);
                    return this.playEatingSound();
                }
                if (this.method_5618() == 0 && this.method_6482() && this.isMatingFood(stack)) {
                    this.method_6480(player);
                    return this.playEatingSound();
                }
            }
            if (this.method_6109()) {
                this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
                if (!this.method_37908().field_9236) {
                    this.method_5615(this.method_6481(stack) ? 10 : 20);
                }
                return this.playEatingSound();
            }
        }
        return false;
    }

    protected boolean playEatingSound() {
        class_3414 soundEvent;
        if (!this.method_5701() && (soundEvent = this.method_28368()) != null) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_6474(@NotNull class_1429 otherAnimal) {
        if (!(otherAnimal instanceof HippocampusEntity)) return false;
        HippocampusEntity camel = (HippocampusEntity)otherAnimal;
        if (!this.method_6734()) return false;
        if (!camel.method_6734()) return false;
        return true;
    }

    protected boolean method_45349() {
        return false;
    }

    public boolean method_5747(float fallDistance, float multiplier, @NotNull class_1282 source) {
        int i = this.method_23329(fallDistance, multiplier);
        if (i <= 0) {
            return false;
        }
        this.method_5643(source, i);
        if (this.method_5782()) {
            for (class_1297 entity : this.method_5736()) {
                entity.method_5643(source, (float)i);
            }
        }
        this.method_23328();
        return true;
    }

    public boolean method_6762() {
        return false;
    }

    public boolean method_18397(@NotNull class_1799 stack) {
        class_1304 equipmentSlot = class_1308.method_32326((class_1799)stack);
        return this.method_6118(equipmentSlot).method_7960() && equipmentSlot == class_1304.field_6173 && super.method_18397(stack);
    }

    protected void method_5949(@NotNull class_1542 itemEntity) {
        class_1799 itemStack;
        if (this.method_6118(class_1304.field_6173).method_7960() && this.method_5939(itemStack = itemEntity.method_6983())) {
            this.method_29499(itemEntity);
            this.method_5673(class_1304.field_6173, itemStack);
            this.method_25939(class_1304.field_6173);
            this.method_6103((class_1297)itemEntity, itemStack.method_7947());
            itemEntity.method_31472();
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)MTSItems.HIPPOCAMPUS_SPAWN_EGG.get());
    }
}

