/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.kraken;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.multipart_entities.entity.EntityBounds;
import com.cerbon.cerbons_api.api.multipart_entities.entity.MultipartAwareEntity;
import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.myths_of_the_sea.entity.custom.kraken.KrakenBodyRotationControl;
import com.cerbon.myths_of_the_sea.entity.custom.kraken.KrakenEntityHitboxes;
import com.cerbon.myths_of_the_sea.entity.custom.kraken.goal.KrakenMeleeAttackGoal;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanMoveControl;
import com.cerbon.myths_of_the_sea.entity.custom.util.BreachingWaterBoundPathNavigation;
import com.cerbon.myths_of_the_sea.entity.custom.util.ExtraReachNearestAttackGoal;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import com.cerbon.myths_of_the_sea.util.GeoControllersUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1332;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1393;
import net.minecraft.class_1408;
import net.minecraft.class_1480;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KrakenEntity
extends class_1480
implements GeoEntity,
MultipartAwareEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation SIMPLE_ATTACK_ANIM = RawAnimation.begin().thenPlay("attack_simple");
    private static final RawAnimation GRAB_ATTACK_ANIM = RawAnimation.begin().thenPlay("attack_grab");
    private static final RawAnimation MOVE_GROUND = RawAnimation.begin().then("move_ground", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation IDLE_GROUND = RawAnimation.begin().then("idle_ground", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation JUMP = RawAnimation.begin().thenPlayAndHold("jump_start");
    public static final RawAnimation LANDING = RawAnimation.begin().thenPlay("jump_landing");
    private static final int ATTACK_ANIM_TIME = 21;
    private final KrakenEntityHitboxes hitboxManager = new KrakenEntityHitboxes(this);
    public static final class_2940<Float> HEALTH_WHEN_START_RIDING = class_2945.method_12791(KrakenEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Boolean> FALLING = class_2945.method_12791(KrakenEntity.class, (class_2941)class_2943.field_13323);
    public float vehicleRotationProgress = 1.0f;
    private final float healthLossToBeReleased = 2.5f;

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(FALLING, (Object)false);
    }

    public float getHealthWhenStartRiding() {
        return ((Float)this.field_6011.method_12789(HEALTH_WHEN_START_RIDING)).floatValue();
    }

    public void setHealthWhenStartRiding(float healthWhenStartRiding) {
        this.field_6011.method_12778(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(healthWhenStartRiding));
    }

    public void setIsFalling(boolean isFalling) {
        this.field_6011.method_12778(FALLING, (Object)isFalling);
    }

    public boolean isFalling() {
        return (Boolean)this.field_6011.method_12789(FALLING);
    }

    public KrakenEntity(class_1299<? extends class_1480> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6194 = 50;
        this.field_6207 = new LeviathanMoveControl((class_1308)this, 85, 10, 0.3f, 0.5f, true);
        this.field_6206 = new class_1332((class_1308)this, 20);
    }

    public static class_5132 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23719, (double)0.21f).method_26868(class_5134.field_23717, 64.0).method_26866();
    }

    public static boolean surfaceWaterSpawnRulesDeepAndNotNearKraken(class_1299<? extends class_1480> waterAnimal, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        int radiusToSearchKraken = 200;
        int seaLevel = level.method_8615();
        int spawnLevel = seaLevel - 70;
        return random.method_43057() <= 0.1f && pos.method_10264() >= spawnLevel && pos.method_10264() <= seaLevel && level.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && level.method_8320(pos.method_10084()).method_27852(class_2246.field_10382) && level.method_8390(KrakenEntity.class, new class_238((double)(pos.method_10263() - radiusToSearchKraken), (double)(pos.method_10264() - radiusToSearchKraken), (double)(pos.method_10260() - radiusToSearchKraken), (double)(pos.method_10263() + radiusToSearchKraken), (double)(pos.method_10264() + radiusToSearchKraken), (double)(pos.method_10260() + radiusToSearchKraken)), kraken -> true).isEmpty();
    }

    public int method_6110() {
        return this.field_6194;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1393((class_1314)this));
        this.field_6201.method_6277(1, (class_1352)new KrakenMeleeAttackGoal(this, 2.0, false));
        this.field_6201.method_6277(2, (class_1352)new class_1378((class_1314)this, 1.0, 10));
        this.field_6201.method_6277(2, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, new ExtraReachNearestAttackGoal<class_1657>((class_1308)this, class_1657.class, 10, false, false, target -> target.method_5799() || target.method_5854() != null && target.method_5854() instanceof class_1690));
        this.field_6185.method_6277(2, new ExtraReachNearestAttackGoal<class_1646>((class_1308)this, class_1646.class, 10, false, false, target -> target.method_5799() || target.method_5854() != null && target.method_5854() instanceof class_1690));
    }

    public boolean method_18395(@NotNull class_1309 target) {
        return super.method_18395(target) && !(target.method_5854() instanceof KrakenEntity) && !this.method_5782();
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5782()) {
            this.vehicleRotationProgress = 0.0f;
        } else if (this.vehicleRotationProgress < 1.0f) {
            float speed = 0.05f;
            this.vehicleRotationProgress = class_3532.method_15363((float)(this.vehicleRotationProgress + speed), (float)0.0f, (float)1.0f);
        }
        if (this.method_5782() && this.field_6012 % 20 == 0) {
            class_1297 passenger = (class_1297)this.method_5685().get(0);
            passenger.method_5643(this.method_48923().method_48812((class_1309)this), 2.0f);
            if (this.method_6032() < this.method_6063()) {
                double f;
                double e;
                double d;
                int i;
                this.method_6025(2.0f);
                for (i = 0; i < 6; ++i) {
                    d = this.field_5974.method_43059() * 0.02;
                    e = this.field_5974.method_43059() * 0.02;
                    f = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_11209, passenger.method_23322(1.0), passenger.method_23319(), passenger.method_23325(1.0), d, e, f);
                    this.method_37908().method_8406((class_2394)class_2398.field_23114, passenger.method_23322(1.0), passenger.method_23319(), passenger.method_23325(1.0), d, e, f);
                }
                for (i = 0; i < 6; ++i) {
                    d = this.field_5974.method_43059() * 0.02;
                    e = this.field_5974.method_43059() * 0.02;
                    f = this.field_5974.method_43059() * 0.02;
                    this.method_37908().method_8406((class_2394)class_2398.field_28479, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), d, e, f);
                }
                this.setHealthWhenStartRiding(this.getHealthWhenStartRiding() + 2.0f);
            }
        }
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.method_5782() && this.method_6032() < this.getHealthWhenStartRiding() - 2.5f) {
            ((class_1297)this.method_5685().get(0)).method_5848();
        }
        return super.method_5643(source, amount);
    }

    @NotNull
    public class_243 method_24829(class_1309 passenger) {
        return new class_243(passenger.method_23317(), passenger.method_5829().field_1325, passenger.method_23321());
    }

    protected void method_5865(@NotNull class_1297 passenger, @NotNull class_1297.class_4738 callback) {
        if (this.method_5626(passenger)) {
            double y = this.method_23318() + this.method_5621() + passenger.method_5678() - (GeoControllersUtil.isMoving((class_1309)this, 0.0015f) ? 4.8 : 2.8);
            float bodyYawRad = this.field_6283 * ((float)Math.PI / 180);
            double forwardOffset = GeoControllersUtil.isMoving((class_1309)this, 0.0015f) ? -1.8 : -0.9;
            double sideOffset = GeoControllersUtil.isMoving((class_1309)this, 0.0015f) ? -3.2 : -2.1;
            double x = this.method_23317() + (double)class_3532.method_15374((float)bodyYawRad) * forwardOffset + (double)class_3532.method_15362((float)bodyYawRad) * sideOffset;
            double z = this.method_23321() - (double)class_3532.method_15362((float)bodyYawRad) * forwardOffset + (double)class_3532.method_15374((float)bodyYawRad) * sideOffset;
            callback.accept(passenger, x, y, z);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 5, state -> {
            if (this.field_6252 && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                state.getController().forceAnimationReset();
                state.getController().setAnimation(this.field_6266.equals((Object)class_1268.field_5810) ? GRAB_ATTACK_ANIM : SIMPLE_ATTACK_ANIM);
                CapabilityUtils.getLevelEventScheduler((class_1937)this.method_37908()).addEvent((IEvent)new TimedEvent(() -> {
                    this.field_6252 = false;
                }, 21));
            }
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, state -> {
            if (this.field_6252) {
                return PlayState.STOP;
            }
            if (!state.isMoving()) {
                return state.setAndContinue(this.method_5799() ? GeoControllersUtil.IDLE_ANIM : IDLE_GROUND);
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.method_5799() ? GeoControllersUtil.MOVE_ANIM : MOVE_GROUND);
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "JumpController", 1, state -> {
            if (this.isFalling()) {
                state.setAnimation(JUMP);
                return PlayState.CONTINUE;
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "LandingController", 1, state -> PlayState.STOP).triggerableAnim("landing", LANDING)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Die", 0, state -> GeoControllersUtil.commonWaterAnimalDie(state, (class_1308)this))});
    }

    @NotNull
    protected class_1330 method_5963() {
        return new KrakenBodyRotationControl(this);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new BreachingWaterBoundPathNavigation((class_1308)this, level);
    }

    public int method_5978() {
        return 1;
    }

    public int method_5986() {
        return 1;
    }

    public int method_20240() {
        return 1;
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), travelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.008, 0.0));
            }
        } else {
            if (!this.method_5799() && !this.isFalling()) {
                class_2338 waterPos = this.findNearestWater(this.method_24515(), 64);
                if (waterPos != null && (this.method_37908().method_8320(waterPos.method_10084()).method_26215() || this.method_37908().method_8316(waterPos.method_10084()).method_39360((class_3611)class_3612.field_15910))) {
                    waterPos = waterPos.method_10089(this.field_5974.method_43051(0, 20));
                    waterPos = waterPos.method_10088(this.field_5974.method_43051(0, 20));
                    waterPos = waterPos.method_10077(this.field_5974.method_43051(0, 20));
                    waterPos = waterPos.method_10076(this.field_5974.method_43051(0, 20));
                    class_243 direction = class_243.method_24953((class_2382)waterPos).method_1020(this.method_19538()).method_1029();
                    class_243 jumpVec = new class_243(direction.field_1352 * 0.8, 0.8, direction.field_1350 * 0.8);
                    this.method_18799(jumpVec);
                } else {
                    waterPos = new class_2338(this.method_24515().method_10263() + this.field_5974.method_39332(1, 20), this.method_24515().method_10264(), this.method_24515().method_10260() + this.field_5974.method_39332(1, 20));
                    class_243 direction = class_243.method_24953((class_2382)waterPos).method_1020(this.method_19538()).method_1029();
                    this.method_18799(new class_243(direction.field_1352 * 0.8, 0.8, direction.field_1350 * 0.8));
                }
                this.method_6043();
                this.setIsFalling(true);
            }
            super.method_6091(travelVector);
        }
    }

    @Nullable
    private class_2338 findNearestWater(class_2338 origin, int radius) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    mutable.method_10103(origin.method_10263() + dx, origin.method_10264() + dy, origin.method_10260() + dz);
                    if (!this.method_37908().method_8320((class_2338)mutable).method_26227().method_39360((class_3611)class_3612.field_15910)) continue;
                    return mutable.method_10062();
                }
            }
        }
        return null;
    }

    protected float method_6106() {
        return 1.5f * this.method_23313() + this.method_37416();
    }

    public void method_38785() {
        if (this.isFalling()) {
            this.setIsFalling(false);
            this.triggerAnim("LandingController", "landing");
            this.method_5783(class_3417.field_15157, 1.0f, 1.0f);
        }
        super.method_38785();
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance, damageMultiplier) - 20;
    }

    public boolean method_6121(@NotNull class_1297 target) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            SoundUtils.playSound((class_3218)serverLevel, (class_243)this.method_19538(), (class_3414)((class_3414)MTSSounds.KRAKEN_ATTACK.get()), (class_3419)class_3419.field_15251, (float)3.0f, (double)6.0);
        }
        return super.method_6121(target);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)MTSSounds.KRAKEN_IDLE.get();
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return (class_3414)MTSSounds.KRAKEN_DAMAGE.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)MTSSounds.KRAKEN_DEATH.get();
    }

    @NotNull
    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public EntityBounds getBounds() {
        return this.hitboxManager.getHitbox();
    }

    public void onSetPos(double x, double y, double z) {
        if (this.hitboxManager != null) {
            this.hitboxManager.updatePosition();
        }
    }

    public void setNextDamagedPart(@Nullable String part) {
    }

    public CompoundOrientedBox getCompoundBoundingBox(class_238 bounds) {
        return this.hitboxManager.getHitbox().getBox(bounds);
    }

    protected float method_18394(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return dimensions.field_18068 * 0.5f;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    protected void method_6108() {
        if (this.method_5782()) {
            class_1297 prey = (class_1297)this.method_5685().get(0);
            prey.method_5848();
        }
        CapabilityUtils.getLevelEventScheduler((class_1937)this.method_37908()).addEvent((IEvent)new TimedEvent(() -> super.method_6108(), 80));
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("HealthWhenStarted", this.getHealthWhenStartRiding());
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setHealthWhenStartRiding(compound.method_10583("HealthWhenStarted"));
    }

    protected void method_6673(int airSupply) {
        if (this.method_5805() && !this.method_5816()) {
            this.method_5855(airSupply - 1);
            if (this.method_5669() == -20) {
                this.method_5855(0);
                this.method_5643(this.method_48923().method_48824(), 2.0f);
            }
        } else {
            this.method_5855(this.method_5748());
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5987()) {
            this.method_5855(this.method_5748());
        }
        if (this.method_24828() && !this.method_5799() && !this.method_29504()) {
            this.method_18799(this.method_18798().method_1031((double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.2f), 0.8, (double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.2f)));
            this.method_36456(this.field_5974.method_43057() * 360.0f);
            this.method_24830(false);
            this.field_6007 = true;
        }
    }

    public int method_5748() {
        return 4800;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)MTSItems.KRAKEN_SPAWN_EGG.get());
    }
}

