/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.myths_of_the_sea.entity.custom.leviathan;

import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.multipart_entities.entity.EntityBounds;
import com.cerbon.cerbons_api.api.multipart_entities.entity.MultipartAwareEntity;
import com.cerbon.cerbons_api.api.multipart_entities.util.CompoundOrientedBox;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanHitboxes;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanMoveControl;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.LeviathanRotationControl;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.goal.LeviathanFleeFromTarget;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.goal.LeviathanMeleeAttackGoal;
import com.cerbon.myths_of_the_sea.entity.custom.leviathan.goal.LeviathanNearestAttackGoal;
import com.cerbon.myths_of_the_sea.entity.custom.util.BreachingWaterBoundPathNavigation;
import com.cerbon.myths_of_the_sea.item.MTSItems;
import com.cerbon.myths_of_the_sea.sound.MTSSounds;
import com.cerbon.myths_of_the_sea.util.GeoControllersUtil;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1332;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1378;
import net.minecraft.class_1393;
import net.minecraft.class_1399;
import net.minecraft.class_1408;
import net.minecraft.class_1480;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LeviathanEntity
extends class_1480
implements GeoEntity,
MultipartAwareEntity {
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final LeviathanHitboxes hitboxManager = new LeviathanHitboxes(this);
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE);
    private static final int ATTACK_ANIM_TIME = 21;
    @Nullable
    private UUID lastPreyUUID;
    @Nullable
    private class_1297 lastPrey;
    public boolean hasAttackedOnWater;
    public int cooldownSwimmingAttackTicks;
    public static final class_2940<Vector3f> BODY_ROT_2 = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_42237);
    public static final class_2940<Vector3f> BODY_ROT_3 = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_42237);
    public static final class_2940<Vector3f> BODY_ROT_4 = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_42237);
    public static final class_2940<Vector3f> BODY_ROT_5 = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_42237);
    public static final class_2940<Vector3f> BODY_ROT_6 = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_42237);
    public static final class_2940<Vector3f> BODY_ROT_7 = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_42237);
    public static final class_2940<Vector3f> BODY_ROT_8 = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_42237);
    public static final class_2940<Float> CLIENT_SIDE_TAIL_ANIMATION = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> CLIENT_SIDE_TAIL_ANIMATION_O = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> CLIENT_SIDE_TAIL_ANIMATION_SPEED = class_2945.method_12791(LeviathanEntity.class, (class_2941)class_2943.field_13320);

    public LeviathanEntity(class_1299<? extends class_1480> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6194 = 50;
        this.field_6207 = new LeviathanMoveControl((class_1308)this, 85, 10, 0.02f, 0.1f, true);
        this.field_6206 = new class_1332((class_1308)this, 10);
        this.field_5985 = true;
        this.setClientSideTailAnimation(this.field_5974.method_43057());
        this.setClientSideTailAnimationO(this.getClientSideTailAnimation());
    }

    public int method_6110() {
        return this.field_6194;
    }

    public static class_5132 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23719, 1.5).method_26868(class_5134.field_23717, 96.0).method_26866();
    }

    public static boolean surfaceWaterSpawnRulesAndNotNearLeviathan(class_1299<? extends class_1480> waterAnimal, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        int radiusToSearchLeviathan = 120;
        int i = level.method_8615();
        int j = i - 13;
        return random.method_43057() <= 0.1f && pos.method_10264() >= j && pos.method_10264() <= i && level.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && level.method_8320(pos.method_10084()).method_27852(class_2246.field_10382) && level.method_8390(LeviathanEntity.class, new class_238((double)(pos.method_10263() - radiusToSearchLeviathan), (double)(pos.method_10264() - radiusToSearchLeviathan), (double)(pos.method_10260() - radiusToSearchLeviathan), (double)(pos.method_10263() + radiusToSearchLeviathan), (double)(pos.method_10264() + radiusToSearchLeviathan), (double)(pos.method_10260() + radiusToSearchLeviathan)), leviathan -> true).isEmpty();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1393((class_1314)this));
        this.field_6201.method_6277(0, (class_1352)new LeviathanFleeFromTarget(this, 2.0, 1));
        this.field_6201.method_6277(1, (class_1352)new LeviathanMeleeAttackGoal(this, 2.0, true, 100));
        this.field_6201.method_6277(3, (class_1352)new class_1378((class_1314)this, 1.0, 200));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(0, new LeviathanNearestAttackGoal<class_1657>(this, class_1657.class, 10, false, false, entity -> this.getLastPrey() != null && entity.method_5779(this.getLastPrey()) && entity.method_5799()));
        this.field_6185.method_6277(1, new LeviathanNearestAttackGoal<class_1657>(this, class_1657.class, 10, false, false, class_1297::method_5799));
        this.field_6185.method_6277(2, new LeviathanNearestAttackGoal<class_1646>(this, class_1646.class, 10, false, false, class_1297::method_5799));
    }

    public void setLastPreyUUID(@Nullable UUID lastPreyUUID) {
        this.lastPreyUUID = lastPreyUUID;
    }

    @Nullable
    public UUID getLastPreyUUID() {
        return this.lastPreyUUID;
    }

    @Nullable
    public class_1297 getLastPrey() {
        return this.lastPrey;
    }

    public void setLastPrey(@Nullable class_1297 lastPrey) {
        this.lastPrey = lastPrey;
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        if (this.getLastPreyUUID() != null) {
            compound.method_25927("LastPrey", this.getLastPreyUUID());
        }
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        if (this.method_37908() instanceof class_3218) {
            if (!compound.method_25928("LastPrey")) {
                this.setLastPreyUUID(null);
            } else {
                UUID uUID = compound.method_25926("LastPrey");
                this.setLastPreyUUID(uUID);
                class_1297 entity = ((class_3218)this.method_37908()).method_14190(uUID);
                if (entity != null) {
                    this.setLastPrey(entity);
                }
            }
        }
    }

    public boolean isSeeingTarget(class_1309 target) {
        class_243 vec3d = target.method_19538();
        class_243 vec3d2 = this.method_5631(0.0f, this.method_5791());
        class_243 vec3d3 = vec3d.method_1035(this.method_19538());
        vec3d3 = new class_243(vec3d3.field_1352, 0.0, vec3d3.field_1350).method_1029();
        return vec3d3.method_1026(vec3d2) < -0.9;
    }

    public boolean method_18395(@NotNull class_1309 target) {
        return super.method_18395(target) && target.method_5799() && !this.hasAttackedOnWater;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Attack", 5, state -> {
            if (this.field_6252 && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                state.getController().forceAnimationReset();
                state.getController().setAnimation(ATTACK_ANIM);
                CapabilityUtils.getLevelEventScheduler((class_1937)this.method_37908()).addEvent((IEvent)new TimedEvent(() -> {
                    this.field_6252 = false;
                }, 21));
            }
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, state -> {
            if (this.field_6252) {
                return PlayState.STOP;
            }
            if (!state.isMoving()) {
                return state.setAndContinue(GeoControllersUtil.IDLE_ANIM);
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Die", 0, state -> GeoControllersUtil.commonWaterAnimalDie(state, (class_1308)this))});
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new BreachingWaterBoundPathNavigation((class_1308)this, level);
    }

    public int method_5978() {
        return 1;
    }

    public int method_5986() {
        return 1;
    }

    public int method_20240() {
        return 1;
    }

    public void method_6091(@NotNull class_243 travelVector) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(this.method_6029(), travelVector);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.008, 0.0));
            }
        } else {
            super.method_6091(travelVector);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5987()) {
            this.method_5855(this.method_5748());
        }
        if (this.method_24828() && !this.method_5799() && !this.method_29504()) {
            this.method_18799(this.method_18798().method_1031((double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.2f), 0.8, (double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.2f)));
            this.method_36456(this.field_5974.method_43057() * 360.0f);
            this.method_24830(false);
            this.field_6007 = true;
        }
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance, damageMultiplier) - 10;
    }

    public EntityBounds getBounds() {
        return this.hitboxManager.getHitbox();
    }

    public void onSetPos(double x, double y, double z) {
        if (this.hitboxManager != null) {
            this.hitboxManager.updatePosition();
        }
    }

    public void setNextDamagedPart(@Nullable String part) {
    }

    public CompoundOrientedBox getCompoundBoundingBox(class_238 bounds) {
        return this.hitboxManager.getHitbox().getBox(bounds);
    }

    public boolean method_6121(@NotNull class_1297 target) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            SoundUtils.playSound((class_3218)serverLevel, (class_243)this.method_19538(), (class_3414)((class_3414)MTSSounds.LEVIATHAN_ATTACK.get()), (class_3419)class_3419.field_15251, (float)3.0f, (double)6.0);
        }
        return super.method_6121(target);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)MTSSounds.LEVIATHAN_IDLE.get();
    }

    @NotNull
    protected class_3414 method_5737() {
        return (class_3414)MTSSounds.LEVIATHAN_MOVEMENT.get();
    }

    protected void method_5734(float volume) {
        float f = (float)this.method_18798().method_37267();
        if (f >= 0.01f) {
            super.method_5734(class_3532.method_16439((float)class_3532.method_15363((float)f, (float)0.0f, (float)0.5f), (float)0.0f, (float)1.2f));
        }
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return (class_3414)MTSSounds.LEVIATHAN_DAMAGE.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)MTSSounds.LEVIATHAN_DEATH.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }

    @NotNull
    protected class_1330 method_5963() {
        return new LeviathanRotationControl(this);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(BODY_ROT_2, (Object)new Vector3f());
        this.method_5841().method_12784(BODY_ROT_3, (Object)new Vector3f());
        this.method_5841().method_12784(BODY_ROT_4, (Object)new Vector3f());
        this.method_5841().method_12784(BODY_ROT_5, (Object)new Vector3f());
        this.method_5841().method_12784(BODY_ROT_6, (Object)new Vector3f());
        this.method_5841().method_12784(BODY_ROT_7, (Object)new Vector3f());
        this.method_5841().method_12784(BODY_ROT_8, (Object)new Vector3f());
        this.method_5841().method_12784(CLIENT_SIDE_TAIL_ANIMATION, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(CLIENT_SIDE_TAIL_ANIMATION_O, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(CLIENT_SIDE_TAIL_ANIMATION_SPEED, (Object)Float.valueOf(0.0f));
    }

    public float getYRot2() {
        return ((Vector3f)this.field_6011.method_12789(LeviathanEntity.BODY_ROT_2)).y;
    }

    public float getYRot3() {
        return ((Vector3f)this.field_6011.method_12789(LeviathanEntity.BODY_ROT_3)).y;
    }

    public float getYRot4() {
        return ((Vector3f)this.field_6011.method_12789(LeviathanEntity.BODY_ROT_4)).y;
    }

    public float getYRot5() {
        return ((Vector3f)this.field_6011.method_12789(LeviathanEntity.BODY_ROT_5)).y;
    }

    public float getYRot6() {
        return ((Vector3f)this.field_6011.method_12789(LeviathanEntity.BODY_ROT_6)).y;
    }

    public float getYRot7() {
        return ((Vector3f)this.field_6011.method_12789(LeviathanEntity.BODY_ROT_7)).y;
    }

    public float getYRot8() {
        return ((Vector3f)this.field_6011.method_12789(LeviathanEntity.BODY_ROT_8)).y;
    }

    public void setYRot2(float YRot2) {
        Vector3f actualVector = (Vector3f)this.field_6011.method_12789(BODY_ROT_2);
        this.field_6011.method_12778(BODY_ROT_2, (Object)new Vector3f(actualVector.x, YRot2, actualVector.z));
    }

    public void setYRot3(float YRot3) {
        Vector3f actualVector = (Vector3f)this.field_6011.method_12789(BODY_ROT_3);
        this.field_6011.method_12778(BODY_ROT_3, (Object)new Vector3f(actualVector.x, YRot3, actualVector.z));
    }

    public void setYRot4(float YRot4) {
        Vector3f actualVector = (Vector3f)this.field_6011.method_12789(BODY_ROT_4);
        this.field_6011.method_12778(BODY_ROT_4, (Object)new Vector3f(actualVector.x, YRot4, actualVector.z));
    }

    public void setYRot5(float YRot5) {
        Vector3f actualVector = (Vector3f)this.field_6011.method_12789(BODY_ROT_5);
        this.field_6011.method_12778(BODY_ROT_5, (Object)new Vector3f(actualVector.x, YRot5, actualVector.z));
    }

    public void setYRot6(float YRot6) {
        Vector3f actualVector = (Vector3f)this.field_6011.method_12789(BODY_ROT_6);
        this.field_6011.method_12778(BODY_ROT_6, (Object)new Vector3f(actualVector.x, YRot6, actualVector.z));
    }

    public void setYRot7(float YRot7) {
        Vector3f actualVector = (Vector3f)this.field_6011.method_12789(BODY_ROT_7);
        this.field_6011.method_12778(BODY_ROT_7, (Object)new Vector3f(actualVector.x, YRot7, actualVector.z));
    }

    public void setYRot8(float YRot8) {
        Vector3f actualVector = (Vector3f)this.field_6011.method_12789(BODY_ROT_8);
        this.field_6011.method_12778(BODY_ROT_8, (Object)new Vector3f(actualVector.x, YRot8, actualVector.z));
    }

    public float getClientSideTailAnimation() {
        return ((Float)this.field_6011.method_12789(CLIENT_SIDE_TAIL_ANIMATION)).floatValue();
    }

    public float getClientSideTailAnimationO() {
        return ((Float)this.field_6011.method_12789(CLIENT_SIDE_TAIL_ANIMATION_O)).floatValue();
    }

    public float getClientSideTailAnimationSpeed() {
        return ((Float)this.field_6011.method_12789(CLIENT_SIDE_TAIL_ANIMATION_SPEED)).floatValue();
    }

    public void setClientSideTailAnimation(float clientSideTailAnimation) {
        this.field_6011.method_12778(CLIENT_SIDE_TAIL_ANIMATION, (Object)Float.valueOf(clientSideTailAnimation));
    }

    public void setClientSideTailAnimationO(float clientSideTailAnimationO) {
        this.field_6011.method_12778(CLIENT_SIDE_TAIL_ANIMATION_O, (Object)Float.valueOf(clientSideTailAnimationO));
    }

    public void setClientSideTailAnimationSpeed(float clientSideTailAnimationSpeed) {
        this.field_6011.method_12778(CLIENT_SIDE_TAIL_ANIMATION_SPEED, (Object)Float.valueOf(clientSideTailAnimationSpeed));
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().field_9236) {
            return;
        }
        this.setClientSideTailAnimationO(this.getClientSideTailAnimation());
        if (this.method_18798().method_1033() != 0.0) {
            float updatedSpeed = this.getClientSideTailAnimationSpeed() + (0.05f - this.getClientSideTailAnimationSpeed()) * 0.1f;
            this.setClientSideTailAnimationSpeed(updatedSpeed);
        } else {
            float updatedSpeed = this.getClientSideTailAnimationSpeed() + (0.025f - this.getClientSideTailAnimationSpeed()) * 0.2f;
            this.setClientSideTailAnimationSpeed(updatedSpeed);
        }
        this.setClientSideTailAnimation(this.getClientSideTailAnimation() + this.getClientSideTailAnimationSpeed());
    }

    public float getTailAnimation(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.getClientSideTailAnimationO(), (float)this.getClientSideTailAnimation());
    }

    protected void method_6108() {
        CapabilityUtils.getLevelEventScheduler((class_1937)this.method_37908()).addEvent((IEvent)new TimedEvent(() -> super.method_6108(), 80));
    }

    public int method_5748() {
        return 6000;
    }

    protected float method_18394(@NotNull class_4050 pose, @NotNull class_4048 dimensions) {
        return 0.85f;
    }

    @NotNull
    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)MTSItems.LEVIATHAN_SPAWN_EGG.get());
    }
}

