/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.gui.components;

import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public interface RenderableComponent {
    public int getWidth(class_327 var1);

    public void renderComponent(class_332 var1, class_327 var2, int var3, int var4);

    public static int getFullWidth(Stream<RenderableComponent> stream, class_327 font) {
        return stream.mapToInt(component -> component.getWidth(font)).sum();
    }

    public static void renderComponents(class_332 guiGraphics, class_327 font, int posX, int posY, Collection<RenderableComponent> list) {
        posX -= RenderableComponent.getFullWidth(list.stream(), font) / 2;
        for (RenderableComponent component : list) {
            component.renderComponent(guiGraphics, font, posX, posY);
            posX += component.getWidth(font);
        }
    }

    public static RenderableComponent ofText(final class_2561 component) {
        return new RenderableComponent(){

            @Override
            public int getWidth(class_327 font) {
                return font.method_27525((class_5348)component);
            }

            @Override
            public void renderComponent(class_332 guiGraphics, class_327 font, int posX, int posY) {
                guiGraphics.method_51439(font, component, posX, posY, -12566464, false);
            }
        };
    }

    public static RenderableComponent ofSprite(class_2960 resourceLocation, int iconSize) {
        return RenderableComponent.ofSprite(resourceLocation, resourceLocation, iconSize, iconSize);
    }

    public static RenderableComponent ofSprite(final class_2960 foregroundLocation, final @Nullable class_2960 backgroundLocation, final int iconSize, final int iconWidth) {
        final int iconOffsetX = (iconWidth - iconSize) / 2;
        return new RenderableComponent(){

            @Override
            public int getWidth(class_327 font) {
                return iconWidth;
            }

            @Override
            public void renderComponent(class_332 guiGraphics, class_327 font, int posX, int posY) {
                if (backgroundLocation != null) {
                    guiGraphics.method_52706(class_10799.field_56883, backgroundLocation, posX + iconOffsetX, posY, iconSize, iconSize);
                }
                guiGraphics.method_52706(class_10799.field_56883, foregroundLocation, posX + iconOffsetX, posY, iconSize, iconSize);
            }
        };
    }
}

