/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests.lootr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.trivialcraft.riddlerchests.RiddlerChests;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;

public class RiddleFileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_DIR = "riddlerchests";
    private static final String RIDDLES_FILE = "riddles.json";
    private static List<RiddleEntry> riddles = null;

    public static List<RiddleEntry> loadRiddles() {
        if (riddles != null) {
            return riddles;
        }
        Path riddlesPath = RiddleFileManager.getRiddlesPath();
        File riddlesFile = riddlesPath.toFile();
        if (riddlesFile.exists()) {
            List<RiddleEntry> list;
            FileReader reader = new FileReader(riddlesFile);
            try {
                Type listType = new TypeToken<ArrayList<RiddleEntry>>(){}.getType();
                riddles = (List)GSON.fromJson((Reader)reader, listType);
                if (riddles == null || riddles.isEmpty()) {
                    RiddlerChests.LOGGER.warn("Riddles file is empty, creating defaults");
                    riddles = RiddleFileManager.createDefaultRiddles();
                    RiddleFileManager.saveRiddles();
                } else {
                    RiddlerChests.LOGGER.info("Loaded {} riddles from {}", (Object)riddles.size(), (Object)riddlesPath);
                }
                list = riddles;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    RiddlerChests.LOGGER.error("Failed to load riddles file, using defaults", (Throwable)e);
                    riddles = RiddleFileManager.createDefaultRiddles();
                    RiddleFileManager.saveRiddles();
                    return riddles;
                }
            }
            reader.close();
            return list;
        }
        riddles = RiddleFileManager.createDefaultRiddles();
        RiddleFileManager.saveRiddles();
        RiddlerChests.LOGGER.info("Created default riddles file at {}", (Object)riddlesPath);
        return riddles;
    }

    private static List<RiddleEntry> createDefaultRiddles() {
        ArrayList<RiddleEntry> defaultRiddles = new ArrayList<RiddleEntry>();
        defaultRiddles.add(new RiddleEntry("I speak without a mouth and hear without ears. I have no body, but I come alive with wind. What am I?", new String[]{"echo"}, true, "Classic riddle about sound reflection"));
        defaultRiddles.add(new RiddleEntry("What has keys but no locks, space but no room, and you can enter but can't go inside?", new String[]{"keyboard"}, true, "Technology riddle"));
        defaultRiddles.add(new RiddleEntry("I'm tall when I'm young, and I'm short when I'm old. What am I?", new String[]{"candle"}, true, "Fire and light"));
        defaultRiddles.add(new RiddleEntry("What gets wet while drying?", new String[]{"towel"}, true, "Bathroom item"));
        defaultRiddles.add(new RiddleEntry("I can travel around the world while staying in a corner. What am I?", new String[]{"stamp"}, true, "Mail riddle"));
        defaultRiddles.add(new RiddleEntry("I have cities, but no houses. I have mountains, but no trees. I have water, but no fish. What am I?", new String[]{"map"}, true, "Geography riddle"));
        defaultRiddles.add(new RiddleEntry("The more you take, the more you leave behind. What am I?", new String[]{"footsteps", "steps"}, true, "Walking riddle"));
        defaultRiddles.add(new RiddleEntry("I have a head and a tail but no body. What am I?", new String[]{"coin"}, true, "Money riddle"));
        defaultRiddles.add(new RiddleEntry("Light as a feather, yet the strongest person can't hold me for five minutes. What am I?", new String[]{"breath"}, true, "Body function"));
        defaultRiddles.add(new RiddleEntry("What begins with T, ends with T, and has T in it?", new String[]{"teapot"}, true, "Wordplay riddle"));
        return defaultRiddles;
    }

    public static void saveRiddles() {
        if (riddles == null) {
            return;
        }
        Path riddlesPath = RiddleFileManager.getRiddlesPath();
        try {
            Files.createDirectories(riddlesPath.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(riddlesPath.toFile());){
                GSON.toJson(riddles, (Appendable)writer);
                RiddlerChests.LOGGER.info("Saved {} riddles to {}", (Object)riddles.size(), (Object)riddlesPath);
            }
        }
        catch (IOException e) {
            RiddlerChests.LOGGER.error("Failed to save riddles file", (Throwable)e);
        }
    }

    private static Path getRiddlesPath() {
        return FMLPaths.CONFIGDIR.get().resolve(CONFIG_DIR).resolve(RIDDLES_FILE);
    }

    public static void reload() {
        riddles = null;
        RiddleFileManager.loadRiddles();
        RiddlerChests.LOGGER.info("Reloaded riddles file");
    }

    public static List<RiddleEntry> getEnabledRiddles() {
        List<RiddleEntry> allRiddles = RiddleFileManager.loadRiddles();
        ArrayList<RiddleEntry> enabled = new ArrayList<RiddleEntry>();
        for (RiddleEntry riddle : allRiddles) {
            if (!riddle.enabled) continue;
            enabled.add(riddle);
        }
        return enabled;
    }

    public static class RiddleEntry {
        public String question;
        public String[] answers;
        public boolean enabled;
        public String description;

        public RiddleEntry() {
        }

        public RiddleEntry(String question, String[] answers, boolean enabled, String description) {
            this.question = question;
            this.answers = answers;
            this.enabled = enabled;
            this.description = description;
        }

        public boolean isCorrectAnswer(String playerAnswer) {
            String normalized = playerAnswer.toLowerCase().trim();
            for (String validAnswer : this.answers) {
                if (!validAnswer.toLowerCase().trim().equals(normalized)) continue;
                return true;
            }
            return false;
        }

        public String getPrimaryAnswer() {
            return this.answers.length > 0 ? this.answers[0] : "";
        }
    }
}

