/*
 * Decompiled with CFR 0.152.
 */
package com.trivialcraft.riddlerchests.lootr;

import com.trivialcraft.riddlerchests.RiddlerChests;
import com.trivialcraft.riddlerchests.lootr.RiddleFileManager;
import com.trivialcraft.riddlerchests.lootr.RiddlerConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

public class RiddleManager
extends SavedData {
    private static final String DATA_NAME = "riddlechest_data";
    private final Map<UUID, Integer> chestRiddles = new HashMap<UUID, Integer>();
    private final Map<UUID, Set<UUID>> solvedRiddles = new HashMap<UUID, Set<UUID>>();

    public static String getRiddleForChest(UUID chestUUID, MinecraftServer server) {
        RiddleManager manager = RiddleManager.get(server);
        List<RiddleFileManager.RiddleEntry> riddles = RiddleFileManager.getEnabledRiddles();
        if (riddles.isEmpty()) {
            RiddlerChests.LOGGER.warn("No riddles available!");
            return "No riddles configured. Please add riddles to config/riddlerchests/riddles.json";
        }
        Integer riddleIndex = manager.chestRiddles.get(chestUUID);
        if (riddleIndex == null || riddleIndex >= riddles.size()) {
            riddleIndex = new Random().nextInt(riddles.size());
            manager.chestRiddles.put(chestUUID, riddleIndex);
            manager.setDirty();
        }
        return riddles.get((int)riddleIndex.intValue()).question;
    }

    public static boolean validateAnswer(UUID chestUUID, String answer, MinecraftServer server) {
        RiddleManager manager = RiddleManager.get(server);
        List<RiddleFileManager.RiddleEntry> riddles = RiddleFileManager.getEnabledRiddles();
        if (riddles.isEmpty()) {
            return false;
        }
        Integer riddleIndex = manager.chestRiddles.get(chestUUID);
        if (riddleIndex == null || riddleIndex >= riddles.size()) {
            return false;
        }
        RiddleFileManager.RiddleEntry riddle = riddles.get(riddleIndex);
        return riddle.isCorrectAnswer(answer);
    }

    public static void markChestAccessed(UUID chestUUID, UUID playerUUID, MinecraftServer server) {
        RiddleManager manager = RiddleManager.get(server);
        manager.solvedRiddles.computeIfAbsent(chestUUID, k -> new HashSet()).add(playerUUID);
        manager.setDirty();
    }

    public static boolean hasPlayerAccessedChest(UUID chestUUID, UUID playerUUID, MinecraftServer server) {
        RiddleManager manager = RiddleManager.get(server);
        Set<UUID> solvers = manager.solvedRiddles.get(chestUUID);
        return solvers != null && solvers.contains(playerUUID);
    }

    private static RiddleManager get(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (RiddleManager)storage.computeIfAbsent(new SavedData.Factory(RiddleManager::new, RiddleManager::load, null), DATA_NAME);
    }

    public static boolean doesPlayerNeedRiddle(UUID chestUUID, UUID playerUUID, MinecraftServer server) {
        RiddleManager manager = RiddleManager.get(server);
        Set<UUID> solvers = manager.solvedRiddles.get(chestUUID);
        if (solvers != null && solvers.contains(playerUUID)) {
            return false;
        }
        return RiddlerConfig.shouldShowRiddle();
    }

    public static RiddleManager load(CompoundTag nbt, HolderLookup.Provider provider) {
        UUID chestUUID;
        CompoundTag entry;
        ListTag list;
        RiddleManager manager = new RiddleManager();
        if (nbt.contains("ChestRiddles", 9)) {
            list = nbt.getList("ChestRiddles", 10);
            for (Tag tag : list) {
                entry = (CompoundTag)tag;
                if (!entry.hasUUID("ChestUUID")) continue;
                chestUUID = entry.getUUID("ChestUUID");
                int riddleIndex = entry.getInt("RiddleIndex");
                manager.chestRiddles.put(chestUUID, riddleIndex);
            }
        }
        if (nbt.contains("SolvedRiddles", 9)) {
            list = nbt.getList("SolvedRiddles", 10);
            for (Tag tag : list) {
                entry = (CompoundTag)tag;
                if (!entry.hasUUID("ChestUUID")) continue;
                chestUUID = entry.getUUID("ChestUUID");
                HashSet<UUID> solvers = new HashSet<UUID>();
                if (entry.contains("Solvers", 9)) {
                    ListTag solversList = entry.getList("Solvers", 11);
                    for (Tag solverTag : solversList) {
                        solvers.add(NbtUtils.loadUUID((Tag)solverTag));
                    }
                }
                manager.solvedRiddles.put(chestUUID, solvers);
            }
        }
        return manager;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag chestList = new ListTag();
        for (Map.Entry<UUID, Integer> entry : this.chestRiddles.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putUUID("ChestUUID", entry.getKey());
            entryTag.putInt("RiddleIndex", entry.getValue().intValue());
            chestList.add((Object)entryTag);
        }
        nbt.put("ChestRiddles", (Tag)chestList);
        ListTag solvedList = new ListTag();
        for (Map.Entry<UUID, Set<UUID>> entry : this.solvedRiddles.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putUUID("ChestUUID", entry.getKey());
            ListTag solversList = new ListTag();
            for (UUID solverUUID : entry.getValue()) {
                solversList.add((Object)NbtUtils.createUUID((UUID)solverUUID));
            }
            entryTag.put("Solvers", (Tag)solversList);
            solvedList.add((Object)entryTag);
        }
        nbt.put("SolvedRiddles", (Tag)solvedList);
        return nbt;
    }
}

