/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record StriderPredicate(Optional<Boolean> cold) implements EntitySubPredicate
{
    public static final MapCodec<StriderPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("cold").forGetter(StriderPredicate::cold)).apply((Applicative)instance, StriderPredicate::new));

    public MapCodec<StriderPredicate> codec() {
        return (MapCodec)ModRegistry.STRIDER_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Strider)) {
            return false;
        }
        Strider strider = (Strider)entity;
        return !this.cold.isPresent() || strider.isSuffocating() == this.cold.get().booleanValue();
    }

    public static StriderPredicate isCold(boolean cold) {
        return new StriderPredicate(Optional.of(cold));
    }
}

