/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.alltheheads.client.handler.CustomHeadLayerHandler;
import fuzs.alltheheads.client.renderer.blockentity.MobHeadRenderer;
import fuzs.alltheheads.client.renderer.blockentity.state.MobHeadRenderState;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Holder;

public class MobHeadLayer<S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final Function<ModelType, SkullModelBase> skullModelGetter;
    private final CustomHeadLayer.Transforms transforms;

    public MobHeadLayer(RenderLayerParent<S, M> renderer, EntityRendererProvider.Context context, CustomHeadLayer.Transforms transforms) {
        super(renderer);
        this.skullModelGetter = MobHeadRenderer.createSkullModels(context.getModelSet());
        this.transforms = transforms;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, S renderState, float yRot, float xRot) {
        if (RenderStateExtraData.has(renderState, CustomHeadLayerHandler.HEAD_TYPE_RENDER_PROPERTY)) {
            poseStack.pushPose();
            poseStack.scale(this.transforms.horizontalScale(), 1.0f, this.transforms.horizontalScale());
            EntityModel entityModel = this.getParentModel();
            entityModel.root().translateAndRotate(poseStack);
            ((HeadedModel)entityModel).getHead().translateAndRotate(poseStack);
            poseStack.translate(0.0f, this.transforms.skullYOffset(), 0.0f);
            poseStack.scale(1.1875f, -1.1875f, -1.1875f);
            poseStack.translate(-0.5, 0.0, -0.5);
            Optional headType = (Optional)RenderStateExtraData.getOrDefault(renderState, CustomHeadLayerHandler.HEAD_TYPE_RENDER_PROPERTY, Optional.empty());
            MobHeadRenderState mobHeadRenderState = MobHeadRenderState.create(packedLight, 180.0f, ((LivingEntityRenderState)renderState).wornHeadAnimationPos, (Holder<HeadType>)((Holder)headType.orElse(null)), ((LivingEntityRenderState)renderState).ageInTicks, ((LivingEntityRenderState)renderState).outlineColor, false);
            MobHeadRenderer.submitSkull(mobHeadRenderState, poseStack, nodeCollector, this.skullModelGetter);
            poseStack.popPose();
        }
    }
}

