/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.advancements.critereon.WolfPredicate;
import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;

public class WolfHeadType {
    public static final ResourceKey<HeadType> ASHEN_WOLF = HeadTypes.register("wolf/ashen");
    public static final ResourceKey<HeadType> ANGRY_ASHEN_WOLF = HeadTypes.register("wolf/ashen/angry");
    public static final ResourceKey<HeadType> TAME_ASHEN_WOLF = HeadTypes.register("wolf/ashen/tame");
    public static final ResourceKey<HeadType> BLACK_WOLF = HeadTypes.register("wolf/black");
    public static final ResourceKey<HeadType> ANGRY_BLACK_WOLF = HeadTypes.register("wolf/black/angry");
    public static final ResourceKey<HeadType> TAME_BLACK_WOLF = HeadTypes.register("wolf/black/tame");
    public static final ResourceKey<HeadType> CHESTNUT_WOLF = HeadTypes.register("wolf/chestnut");
    public static final ResourceKey<HeadType> ANGRY_CHESTNUT_WOLF = HeadTypes.register("wolf/chestnut/angry");
    public static final ResourceKey<HeadType> TAME_CHESTNUT_WOLF = HeadTypes.register("wolf/chestnut/tame");
    public static final ResourceKey<HeadType> PALE_WOLF = HeadTypes.register("wolf/pale");
    public static final ResourceKey<HeadType> ANGRY_PALE_WOLF = HeadTypes.register("wolf/pale/angry");
    public static final ResourceKey<HeadType> TAME_PALE_WOLF = HeadTypes.register("wolf/pale/tame");
    public static final ResourceKey<HeadType> RUSTY_WOLF = HeadTypes.register("wolf/rusty");
    public static final ResourceKey<HeadType> ANGRY_RUSTY_WOLF = HeadTypes.register("wolf/rusty/angry");
    public static final ResourceKey<HeadType> TAME_RUSTY_WOLF = HeadTypes.register("wolf/rusty/tame");
    public static final ResourceKey<HeadType> SPOTTED_WOLF = HeadTypes.register("wolf/spotted");
    public static final ResourceKey<HeadType> ANGRY_SPOTTED_WOLF = HeadTypes.register("wolf/spotted/angry");
    public static final ResourceKey<HeadType> TAME_SPOTTED_WOLF = HeadTypes.register("wolf/spotted/tame");
    public static final ResourceKey<HeadType> SNOWY_WOLF = HeadTypes.register("wolf/snowy");
    public static final ResourceKey<HeadType> ANGRY_SNOWY_WOLF = HeadTypes.register("wolf/snowy/angry");
    public static final ResourceKey<HeadType> TAME_SNOWY_WOLF = HeadTypes.register("wolf/snowy/tame");
    public static final ResourceKey<HeadType> STRIPED_WOLF = HeadTypes.register("wolf/striped");
    public static final ResourceKey<HeadType> ANGRY_STRIPED_WOLF = HeadTypes.register("wolf/striped/angry");
    public static final ResourceKey<HeadType> TAME_STRIPED_WOLF = HeadTypes.register("wolf/striped/tame");
    public static final ResourceKey<HeadType> WOODS_WOLF = HeadTypes.register("wolf/woods");
    public static final ResourceKey<HeadType> ANGRY_WOODS_WOLF = HeadTypes.register("wolf/woods/angry");
    public static final ResourceKey<HeadType> TAME_WOODS_WOLF = HeadTypes.register("wolf/woods/tame");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.ASHEN, ASHEN_WOLF, "entity/wolf/wolf_ashen");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.ASHEN, ANGRY_ASHEN_WOLF, "entity/wolf/wolf_ashen_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.ASHEN, TAME_ASHEN_WOLF, "entity/wolf/wolf_ashen_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.BLACK, BLACK_WOLF, "entity/wolf/wolf_black");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.BLACK, ANGRY_BLACK_WOLF, "entity/wolf/wolf_black_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.BLACK, TAME_BLACK_WOLF, "entity/wolf/wolf_black_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.CHESTNUT, CHESTNUT_WOLF, "entity/wolf/wolf_chestnut");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.CHESTNUT, ANGRY_CHESTNUT_WOLF, "entity/wolf/wolf_chestnut_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.CHESTNUT, TAME_CHESTNUT_WOLF, "entity/wolf/wolf_chestnut_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.PALE, PALE_WOLF, "entity/wolf/wolf");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.PALE, ANGRY_PALE_WOLF, "entity/wolf/wolf_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.PALE, TAME_PALE_WOLF, "entity/wolf/wolf_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.RUSTY, RUSTY_WOLF, "entity/wolf/wolf_rusty");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.RUSTY, ANGRY_RUSTY_WOLF, "entity/wolf/wolf_rusty_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.RUSTY, TAME_RUSTY_WOLF, "entity/wolf/wolf_rusty_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.SPOTTED, SPOTTED_WOLF, "entity/wolf/wolf_spotted");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.SPOTTED, ANGRY_SPOTTED_WOLF, "entity/wolf/wolf_spotted_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.SPOTTED, TAME_SPOTTED_WOLF, "entity/wolf/wolf_spotted_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.SNOWY, SNOWY_WOLF, "entity/wolf/wolf_snowy");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.SNOWY, ANGRY_SNOWY_WOLF, "entity/wolf/wolf_snowy_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.SNOWY, TAME_SNOWY_WOLF, "entity/wolf/wolf_snowy_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.STRIPED, STRIPED_WOLF, "entity/wolf/wolf_striped");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.STRIPED, ANGRY_STRIPED_WOLF, "entity/wolf/wolf_striped_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.STRIPED, TAME_STRIPED_WOLF, "entity/wolf/wolf_striped_tame");
        WolfHeadType.bootstrapWolf(context, (ResourceKey<WolfVariant>)WolfVariants.WOODS, WOODS_WOLF, "entity/wolf/wolf_woods");
        WolfHeadType.bootstrapAngryWolf(context, (ResourceKey<WolfVariant>)WolfVariants.WOODS, ANGRY_WOODS_WOLF, "entity/wolf/wolf_woods_angry");
        WolfHeadType.bootstrapTameWolf(context, (ResourceKey<WolfVariant>)WolfVariants.WOODS, TAME_WOODS_WOLF, "entity/wolf/wolf_woods_tame");
    }

    private static void bootstrapWolf(BootstrapContext<HeadType> context, ResourceKey<WolfVariant> variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.WOLF).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.WOLF_VARIANT, (Object)context.lookup(Registries.WOLF_VARIANT).getOrThrow(variant))).build()).subPredicate((EntitySubPredicate)new WolfPredicate(Optional.of(false), Optional.of(false)))).shape(6.0, 6.0, 4.0).scale(1.3333333333333333).model(ModelType.WOLF, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound((Holder<SoundEvent>)((WolfSoundVariant)SoundEvents.WOLF_SOUNDS.get(WolfSoundVariants.SoundSet.CLASSIC)).ambientSound()).build(context, resourceKey);
    }

    private static void bootstrapAngryWolf(BootstrapContext<HeadType> context, ResourceKey<WolfVariant> variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.WOLF).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.WOLF_VARIANT, (Object)context.lookup(Registries.WOLF_VARIANT).getOrThrow(variant))).build()).subPredicate((EntitySubPredicate)WolfPredicate.isAngry())).shape(6.0, 6.0, 4.0).scale(1.3333333333333333).model(ModelType.WOLF, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound((Holder<SoundEvent>)((WolfSoundVariant)SoundEvents.WOLF_SOUNDS.get(WolfSoundVariants.SoundSet.CLASSIC)).growlSound()).build(context, resourceKey);
    }

    private static void bootstrapTameWolf(BootstrapContext<HeadType> context, ResourceKey<WolfVariant> variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.WOLF).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.WOLF_VARIANT, (Object)context.lookup(Registries.WOLF_VARIANT).getOrThrow(variant))).build()).subPredicate((EntitySubPredicate)WolfPredicate.isTame())).shape(6.0, 6.0, 4.0).scale(1.3333333333333333).model(ModelType.WOLF, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound((Holder<SoundEvent>)((WolfSoundVariant)SoundEvents.WOLF_SOUNDS.get(WolfSoundVariants.SoundSet.CLASSIC)).pantSound()).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(ASHEN_WOLF, "Ashen Wolf Head");
        translationConsumer.accept(ANGRY_ASHEN_WOLF, "Angry Ashen Wolf Head");
        translationConsumer.accept(TAME_ASHEN_WOLF, "Tame Ashen Wolf Head");
        translationConsumer.accept(BLACK_WOLF, "Black Wolf Head");
        translationConsumer.accept(ANGRY_BLACK_WOLF, "Angry Black Wolf Head");
        translationConsumer.accept(TAME_BLACK_WOLF, "Tame Black Wolf Head");
        translationConsumer.accept(CHESTNUT_WOLF, "Chestnut Wolf Head");
        translationConsumer.accept(ANGRY_CHESTNUT_WOLF, "Angry Chestnut Wolf Head");
        translationConsumer.accept(TAME_CHESTNUT_WOLF, "Tame Chestnut Wolf Head");
        translationConsumer.accept(PALE_WOLF, "Pale Wolf Head");
        translationConsumer.accept(ANGRY_PALE_WOLF, "Angry Pale Wolf Head");
        translationConsumer.accept(TAME_PALE_WOLF, "Tame Pale Wolf Head");
        translationConsumer.accept(RUSTY_WOLF, "Rusty Wolf Head");
        translationConsumer.accept(ANGRY_RUSTY_WOLF, "Angry Rusty Wolf Head");
        translationConsumer.accept(TAME_RUSTY_WOLF, "Tame Rusty Wolf Head");
        translationConsumer.accept(SPOTTED_WOLF, "Spotted Wolf Head");
        translationConsumer.accept(ANGRY_SPOTTED_WOLF, "Angry Spotted Wolf Head");
        translationConsumer.accept(TAME_SPOTTED_WOLF, "Tame Spotted Wolf Head");
        translationConsumer.accept(SNOWY_WOLF, "Snowy Wolf Head");
        translationConsumer.accept(ANGRY_SNOWY_WOLF, "Angry Snowy Wolf Head");
        translationConsumer.accept(TAME_SNOWY_WOLF, "Tame Snowy Wolf Head");
        translationConsumer.accept(STRIPED_WOLF, "Striped Wolf Head");
        translationConsumer.accept(ANGRY_STRIPED_WOLF, "Angry Striped Wolf Head");
        translationConsumer.accept(TAME_STRIPED_WOLF, "Tame Striped Wolf Head");
        translationConsumer.accept(WOODS_WOLF, "Woods Wolf Head");
        translationConsumer.accept(ANGRY_WOODS_WOLF, "Angry Woods Wolf Head");
        translationConsumer.accept(TAME_WOODS_WOLF, "Tame Woods Wolf Head");
    }
}

