/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.item.component.headtype;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public record Shape(double width, double height, double depth, double scale, Int2ObjectMap<VoxelShape> verticalShapes, Map<Direction, VoxelShape> horizontalShapes) {
    public static final Codec<Shape> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)1.0, (double)24.0).fieldOf("width").forGetter(Shape::width), (App)Codec.doubleRange((double)1.0, (double)24.0).fieldOf("height").forGetter(Shape::height), (App)Codec.doubleRange((double)1.0, (double)24.0).fieldOf("depth").forGetter(Shape::depth), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf("scale", (Object)1.0).forGetter(Shape::scale)).apply((Applicative)instance, Shape::new));
    public static final StreamCodec<ByteBuf, Shape> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, Shape::scaledWidth, (StreamCodec)ByteBufCodecs.DOUBLE, Shape::scaledHeight, (StreamCodec)ByteBufCodecs.DOUBLE, Shape::scaledDepth, Shape::new);

    public Shape(double width, double height, double depth) {
        this(width, height, depth, 1.0);
    }

    private Shape(double width, double height, double depth, double scale) {
        this(width, height, depth, scale, (Int2ObjectMap<VoxelShape>)((Int2ObjectMap)Util.make((Object)new Int2ObjectArrayMap(), map -> {
            Map rotatedShapes = Shapes.rotateHorizontal((VoxelShape)Block.column((double)(width * scale), (double)(depth * scale), (double)0.0, (double)(height * scale)));
            for (int i = 0; i <= RotationSegment.getMaxSegmentIndex(); ++i) {
                map.put(i, (Object)RotationSegment.convertToDirection((int)i).map(rotatedShapes::get).orElseGet(() -> Block.column((double)(Math.max(width, depth) * scale), (double)0.0, (double)(height * scale))));
            }
        })), Shapes.rotateHorizontal((VoxelShape)Block.boxZ((double)(width * scale), (double)(8.0 - height * scale / 2.0), (double)(8.0 + height * scale / 2.0), (double)(16.0 - depth * scale), (double)16.0)));
    }

    public Shape scale(double scale) {
        return new Shape(this.width, this.height, this.depth, this.scale * scale);
    }

    private double scaledWidth() {
        return this.width * this.scale;
    }

    private double scaledHeight() {
        return this.height * this.scale;
    }

    private double scaledDepth() {
        return this.depth * this.scale;
    }

    public double sizeX(Direction direction) {
        return direction.getAxis() != Direction.Axis.Z ? this.scaledDepth() : this.scaledWidth();
    }

    public double sizeY() {
        return this.scaledHeight();
    }

    public double sizeZ(Direction direction) {
        return direction.getAxis() == Direction.Axis.Z ? this.scaledDepth() : this.scaledWidth();
    }
}

