/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.data.loot;

import com.google.common.collect.ImmutableMap;
import fuzs.alltheheads.AllTheHeads;
import fuzs.alltheheads.init.ModLootTables;
import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.init.headtype.AnimalHeadType;
import fuzs.alltheheads.init.headtype.AquaticHeadType;
import fuzs.alltheheads.init.headtype.AxolotlHeadType;
import fuzs.alltheheads.init.headtype.BeeHeadType;
import fuzs.alltheheads.init.headtype.CatHeadType;
import fuzs.alltheheads.init.headtype.ChickenHeadType;
import fuzs.alltheheads.init.headtype.CopperGolemHeadType;
import fuzs.alltheheads.init.headtype.CowHeadType;
import fuzs.alltheheads.init.headtype.FoxHeadType;
import fuzs.alltheheads.init.headtype.FrogHeadType;
import fuzs.alltheheads.init.headtype.GhastHeadType;
import fuzs.alltheheads.init.headtype.GuardianHeadType;
import fuzs.alltheheads.init.headtype.HoglinHeadType;
import fuzs.alltheheads.init.headtype.HorseHeadType;
import fuzs.alltheheads.init.headtype.IllagerHeadType;
import fuzs.alltheheads.init.headtype.LlamaHeadType;
import fuzs.alltheheads.init.headtype.MonsterHeadType;
import fuzs.alltheheads.init.headtype.PandaHeadType;
import fuzs.alltheheads.init.headtype.ParrotHeadType;
import fuzs.alltheheads.init.headtype.PigHeadType;
import fuzs.alltheheads.init.headtype.PiglinHeadType;
import fuzs.alltheheads.init.headtype.RabbitHeadType;
import fuzs.alltheheads.init.headtype.SheepHeadType;
import fuzs.alltheheads.init.headtype.SpiderHeadType;
import fuzs.alltheheads.init.headtype.StriderHeadType;
import fuzs.alltheheads.init.headtype.TropicalFishHeadType;
import fuzs.alltheheads.init.headtype.VexHeadType;
import fuzs.alltheheads.init.headtype.VillagerHeadType;
import fuzs.alltheheads.init.headtype.WitherHeadType;
import fuzs.alltheheads.init.headtype.WolfHeadType;
import fuzs.alltheheads.init.headtype.ZombieVillagerHeadType;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.puzzleslib.api.data.v2.AbstractLootProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_117;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_221;
import net.minecraft.class_225;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_9320;
import net.minecraft.class_9331;

public class ModEntityLootProvider
extends AbstractLootProvider.Simple {
    private static final Map<class_5321<HeadType>, RandomChanceWithLooting> HEAD_TYPE_LOOT_DROP_CHANCES;

    private static void registerDropChance(class_5321<HeadType> headType, float base, float perLevelAfterFirst, BiConsumer<class_5321<HeadType>, RandomChanceWithLooting> builder) {
        builder.accept(headType, new RandomChanceWithLooting(base, perLevelAfterFirst));
    }

    public ModEntityLootProvider(DataProviderContext context) {
        super(class_173.field_1173, context);
    }

    public void addLootTables() {
        this.registries().method_46762(ModRegistry.HEAD_REGISTRY_KEY).method_42017().forEach(this::dropHead);
        this.dropVanillaHead(ModLootTables.ZOMBIE_INJECTION, class_1802.field_8470);
        this.dropVanillaHead(ModLootTables.SKELETON_INJECTION, class_1802.field_8398);
        this.dropVanillaHead(ModLootTables.CREEPER_INJECTION, class_1802.field_8681);
        this.dropVanillaHead(ModLootTables.PIGLIN_INJECTION, class_1802.field_41304);
        this.dropVanillaHead(ModLootTables.ENDER_DRAGON_INJECTION, class_1802.field_8712);
    }

    public final void dropHead(class_6880.class_6883<HeadType> headType) {
        ((HeadType)headType.comp_349()).loot().lootTable().ifPresent(resourceKey -> {
            RandomChanceWithLooting randomChanceWithLooting = HEAD_TYPE_LOOT_DROP_CHANCES.getOrDefault(headType.method_40237(), RandomChanceWithLooting.DEFAULT);
            if (randomChanceWithLooting == RandomChanceWithLooting.DEFAULT) {
                AllTheHeads.LOGGER.warn("Missing head type loot drop chance for {}", (Object)headType.method_40237());
            }
            this.add((class_5321)resourceKey, class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)ModRegistry.MOB_HEAD_ITEM.comp_349()))).method_353((class_117.class_118)class_9320.method_57650((class_9331)((class_9331)ModRegistry.HEAD_TYPE_DATA_COMPONENT_TYPE.comp_349()), (Object)headType)).method_356(class_221.method_939()).method_356(class_225.method_953((class_7225.class_7874)this.registries(), (float)randomChanceWithLooting.randomChance(), (float)randomChanceWithLooting.lootingLevelBonus()))));
        });
    }

    public final void dropVanillaHead(class_5321<class_52> resourceKey, class_1792 item) {
        this.add(resourceKey, class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)item)).method_356(class_221.method_939()).method_356(class_225.method_953((class_7225.class_7874)this.registries(), (float)RandomChanceWithLooting.DEFAULT.randomChance(), (float)RandomChanceWithLooting.DEFAULT.lootingLevelBonus()))));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ModEntityLootProvider.registerDropChance(AquaticHeadType.DOLPHIN, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(IllagerHeadType.VINDICATOR, 0.05f, 0.015f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AquaticHeadType.GLOW_SQUID, 0.05f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AquaticHeadType.COD, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.GOAT, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PigHeadType.TEMPERATE_PIG, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PigHeadType.WARM_PIG, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PigHeadType.COLD_PIG, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(GuardianHeadType.ELDER_GUARDIAN, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WitherHeadType.WITHER, 0.5f, 0.1f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WitherHeadType.SHIELED_WITHER, 0.5f, 0.1f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WitherHeadType.BLUE_WITHER, 0.5f, 0.1f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WitherHeadType.SHIELDED_BLUE_WITHER, 0.5f, 0.1f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_ARMORER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_BUTCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_CARTOGRAPHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_CLERIC_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_FARMER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_FISHERMAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_FLETCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_LEATHERWORKER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_LIBRARIAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_MASON_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_NITWIT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_SHEPHERD_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_TOOLSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.DESERT_WEAPONSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_ARMORER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_BUTCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_CARTOGRAPHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_CLERIC_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_FARMER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_FISHERMAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_FLETCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_LEATHERWORKER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_LIBRARIAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_MASON_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_NITWIT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_SHEPHERD_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_TOOLSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.JUNGLE_WEAPONSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_ARMORER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_BUTCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_CARTOGRAPHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_CLERIC_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_FARMER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_FISHERMAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_FLETCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_LEATHERWORKER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_LIBRARIAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_MASON_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_NITWIT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_SHEPHERD_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_TOOLSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.PLAINS_WEAPONSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_ARMORER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_BUTCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_CARTOGRAPHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_CLERIC_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_FARMER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_FISHERMAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_FLETCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_LEATHERWORKER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_LIBRARIAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_MASON_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_NITWIT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_SHEPHERD_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_TOOLSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SAVANNA_WEAPONSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_ARMORER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_BUTCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_CARTOGRAPHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_CLERIC_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_FARMER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_FISHERMAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_FLETCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_LEATHERWORKER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_LIBRARIAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_MASON_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_NITWIT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_SHEPHERD_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_TOOLSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SNOW_WEAPONSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_ARMORER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_BUTCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_CARTOGRAPHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_CLERIC_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_FARMER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_FISHERMAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_FLETCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_LEATHERWORKER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_LIBRARIAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_MASON_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_NITWIT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_SHEPHERD_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_TOOLSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.SWAMP_WEAPONSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_ARMORER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_BUTCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_CARTOGRAPHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_CLERIC_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_FARMER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_FISHERMAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_FLETCHER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_LEATHERWORKER_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_LIBRARIAN_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_MASON_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_NITWIT_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_SHEPHERD_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_TOOLSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VillagerHeadType.TAIGA_WEAPONSMITH_VILLAGER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.CREAMY_TRADER_LLAMA, 0.24f, 0.07f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.WHITE_TRADER_LLAMA, 0.24f, 0.07f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.BROWN_TRADER_LLAMA, 0.24f, 0.07f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.GRAY_TRADER_LLAMA, 0.24f, 0.07f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PandaHeadType.AGGRESSIVE_PANDA, 0.27f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PandaHeadType.LAZY_PANDA, 0.27f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PandaHeadType.PLAYFUL_PANDA, 0.27f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PandaHeadType.WORRIED_PANDA, 0.27f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PandaHeadType.BROWN_PANDA, 0.27f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PandaHeadType.WEAK_PANDA, 0.27f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PandaHeadType.PANDA, 0.27f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SpiderHeadType.CAVE_SPIDER, 0.005f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.ZOMBIE_HORSE, 0.2f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.DONKEY, 0.2f, 0.09f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.DROWNED, 0.05f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ChickenHeadType.TEMPERATE_CHICKEN, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ChickenHeadType.WARM_CHICKEN, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ChickenHeadType.COLD_CHICKEN, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.RAVAGER, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AxolotlHeadType.LUCY_AXOLOTL, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AxolotlHeadType.WILD_AXOLOTL, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AxolotlHeadType.GOLD_AXOLOTL, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AxolotlHeadType.CYAN_AXOLOTL, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AxolotlHeadType.BLUE_AXOLOTL, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.SNIFFER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.OCELOT, 0.2f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ASHEN_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_ASHEN_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_ASHEN_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.BLACK_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_BLACK_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_BLACK_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.CHESTNUT_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_CHESTNUT_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_CHESTNUT_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.PALE_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_PALE_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_PALE_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.RUSTY_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_RUSTY_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_RUSTY_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.SPOTTED_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_SPOTTED_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_SPOTTED_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.SNOWY_WOLF, 0.5f, 0.1f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_SNOWY_WOLF, 0.5f, 0.1f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_SNOWY_WOLF, 0.5f, 0.1f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.STRIPED_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_STRIPED_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_STRIPED_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.WOODS_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.ANGRY_WOODS_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(WolfHeadType.TAME_WOODS_WOLF, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(FoxHeadType.FOX, 0.1f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(FoxHeadType.SNOW_FOX, 0.2f, 0.004f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.SHULKER, 0.05f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.CREAMY_LLAMA, 0.24f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.WHITE_LLAMA, 0.24f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.BROWN_LLAMA, 0.24f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(LlamaHeadType.GRAY_LLAMA, 0.24f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.TABBY_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.RED_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.ALL_BLACK_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.SIAMESE_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.BRITISH_SHORTHAIR_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.CALICO_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.PERSIAN_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.RAGDOLL_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.WHITE_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.JELLIE_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CatHeadType.BLACK_CAT, 0.33f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_ARMORER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_BUTCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_CARTOGRAPHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_CLERIC_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_FARMER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_FISHERMAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_FLETCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_LEATHERWORKER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_LIBRARIAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_MASON_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_NITWIT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_SHEPHERD_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_TOOLSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.DESERT_WEAPONSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_ARMORER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_BUTCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_CARTOGRAPHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_CLERIC_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_FARMER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_FISHERMAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_FLETCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_LEATHERWORKER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_LIBRARIAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_MASON_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_NITWIT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_SHEPHERD_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_TOOLSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.JUNGLE_WEAPONSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_ARMORER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_BUTCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_CARTOGRAPHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_CLERIC_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_FARMER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_FISHERMAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_FLETCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_LEATHERWORKER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_LIBRARIAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_MASON_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_NITWIT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_SHEPHERD_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_TOOLSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.PLAINS_WEAPONSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_ARMORER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_BUTCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_CARTOGRAPHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_CLERIC_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_FARMER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_FISHERMAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_FLETCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_LEATHERWORKER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_LIBRARIAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_MASON_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_NITWIT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_SHEPHERD_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_TOOLSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SAVANNA_WEAPONSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_ARMORER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_BUTCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_CARTOGRAPHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_CLERIC_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_FARMER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_FISHERMAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_FLETCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_LEATHERWORKER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_LIBRARIAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_MASON_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_NITWIT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_SHEPHERD_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_TOOLSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SNOW_WEAPONSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_ARMORER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_BUTCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_CARTOGRAPHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_CLERIC_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_FARMER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_FISHERMAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_FLETCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_LEATHERWORKER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_LIBRARIAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_MASON_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_NITWIT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_SHEPHERD_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_TOOLSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.SWAMP_WEAPONSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_ARMORER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_BUTCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_CARTOGRAPHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_CLERIC_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_FARMER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_FISHERMAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_FLETCHER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_LEATHERWORKER_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_LIBRARIAN_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_MASON_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_NITWIT_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_SHEPHERD_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_TOOLSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ZombieVillagerHeadType.TAIGA_WEAPONSMITH_ZOMBIE_VILLAGER, 0.5f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.MULE, 0.2f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.POLAR_BEAR, 0.2f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.BREEZE, 0.1f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(IllagerHeadType.PILLAGER, 0.025f, 0.005f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AquaticHeadType.SALMON, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.HUSK, 0.06f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.GIANT, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CowHeadType.TEMPERATE_COW, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CowHeadType.WARM_COW, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CowHeadType.COLD_COW, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.ANEMONE, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.BLACK_TANG, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.BLUE_TANG, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.BUTTERFLYFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.CICHLID, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.CLOWNFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.COTTON_CANDY_BETTA, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.DOTTYBACK, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.EMPEROR_RED_SNAPPER, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.GOATFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.MOORISH_IDOL, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.ORNATE_BUTTERFLYFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.PARROTFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.QUEEN_ANGELFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.RED_CICHLID, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.RED_LIPPED_BLENNY, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.RED_SNAPPER, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.THREADFIN, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.TOMATO_CLOWNFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.TRIGGERFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.YELLOWTAIL_PARROTFISH, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(TropicalFishHeadType.YELLOW_TANG, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AquaticHeadType.TADPOLE, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(IllagerHeadType.EVOKER, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.ENDERMAN, 0.005f, 1.0E-4f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.CHARGED_CREEPER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PiglinHeadType.PIGLIN_BRUTE, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VexHeadType.ALLAY, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(BeeHeadType.BEE, 0.2f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(BeeHeadType.POLLINATED_BEE, 0.2f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(BeeHeadType.ANGRY_BEE, 0.2f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(BeeHeadType.POLLINATED_ANGRY_BEE, 0.2f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.CREAKING, 0.1f, 0.005f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(FrogHeadType.COLD_FROG, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(FrogHeadType.TEMPERATE_FROG, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(FrogHeadType.WARM_FROG, 0.2f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(PiglinHeadType.ZOMBIFIED_PIGLIN, 0.005f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.SLIME, 0.005f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HoglinHeadType.HOGLIN, 0.03f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.ENDERMITE, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.BOGGED, 0.06f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(GhastHeadType.HAPPY_GHAST, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.WITCH, 0.005f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.SNOW_GOLEM, 0.05f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.WANDERING_TRADER, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.WARDEN, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.CAMEL, 0.2f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.STRAY, 0.06f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CopperGolemHeadType.COPPER_GOLEM, 0.05f, 0.015f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CopperGolemHeadType.EXPOSED_COPPER_GOLEM, 0.05f, 0.015f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CopperGolemHeadType.OXIDIZED_COPPER_GOLEM, 0.05f, 0.015f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CopperGolemHeadType.WEATHERED_COPPER_GOLEM, 0.05f, 0.015f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.IRON_GOLEM, 0.05f, 0.015f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.ARMADILLO, 0.1f, 0.005f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AquaticHeadType.PUFFERFISH, 0.15f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.PHANTOM, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.MAGMA_CUBE, 0.005f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AquaticHeadType.TURTLE, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SpiderHeadType.SPIDER, 0.005f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(StriderHeadType.STRIDER, 0.1f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(StriderHeadType.COLD_STRIDER, 0.1f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ParrotHeadType.RED_PARROT, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ParrotHeadType.BLUE_PARROT, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ParrotHeadType.GREEN_PARROT, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ParrotHeadType.CYAN_PARROT, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(ParrotHeadType.GRAY_PARROT, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.SILVERFISH, 0.05f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AquaticHeadType.SQUID, 0.05f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(GuardianHeadType.GUARDIAN, 0.005f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CowHeadType.RED_MOOSHROOM, 0.01f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(CowHeadType.BROWN_MOOSHROOM, 0.1f, 0.001f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(AnimalHeadType.BAT, 0.1f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.SKELETON_HORSE, 0.2f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(MonsterHeadType.BLAZE, 0.005f, 5.0E-4f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HoglinHeadType.ZOGLIN, 0.2f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.TOAST_RABBIT, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.BROWN_RABBIT, 0.26f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.WHITE_RABBIT, 0.26f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.BLACK_RABBIT, 0.26f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.WHITE_SPLOTCHED_RABBIT, 0.26f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.GOLD_RABBIT, 0.26f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.SALT_RABBIT, 0.26f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(RabbitHeadType.EVIL_RABBIT, 1.0f, 0.0f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(GhastHeadType.GHAST, 0.0625f, 0.0125f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(GhastHeadType.CHARGING_GHAST, 0.0625f, 0.0125f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_WHITE_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_FIELD_WHITE_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DOTS_WHITE_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_DOTS_WHITE_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.CREAMY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_CREAMY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_FIELD_CREAMY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DOTS_CREAMY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_DOTS_CREAMY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.CHESTNUT_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_CHESTNUT_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_FIELD_CHESTNUT_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DOTS_CHESTNUT_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_DOTS_CHESTNUT_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_FIELD_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DOTS_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_DOTS_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_BLACK_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_FIELD_BLACK_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DOTS_BLACK_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_DOTS_BLACK_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.GRAY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_GRAY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_FIELD_GRAY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DOTS_GRAY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_DOTS_GRAY_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.DARK_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DARK_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_FIELD_DARK_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.WHITE_DOTS_DARK_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(HorseHeadType.BLACK_DOTS_DARK_BROWN_HORSE, 0.27f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VexHeadType.VEX, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(VexHeadType.CHARGING_VEX, 0.1f, 0.01f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(IllagerHeadType.ILLUSIONER, 0.25f, 0.02f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.WHITE_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.WHITE_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.ORANGE_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.ORANGE_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.MAGENTA_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.MAGENTA_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.LIGHT_BLUE_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.LIGHT_BLUE_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.YELLOW_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.YELLOW_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.LIME_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.LIME_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.PINK_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.PINK_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.GRAY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.GRAY_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.LIGHT_GRAY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.LIGHT_GRAY_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.CYAN_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.CYAN_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.PURPLE_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.PURPLE_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.BLUE_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.BLUE_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.BROWN_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.BROWN_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.GREEN_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.GREEN_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.RED_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.RED_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.BLACK_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.BLACK_WOOLLY_SHEEP, 0.0175f, 0.0025f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.RAINBOW_SHEEP, 0.1f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        ModEntityLootProvider.registerDropChance(SheepHeadType.RAINBOW_WOOLLY_SHEEP, 0.1f, 0.05f, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        HEAD_TYPE_LOOT_DROP_CHANCES = builder.build();
    }

    private record RandomChanceWithLooting(float randomChance, float lootingLevelBonus) {
        public static final RandomChanceWithLooting DEFAULT = new RandomChanceWithLooting(0.025f, 0.01f);
    }
}

