/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads;

import com.google.common.collect.Sets;
import fuzs.alltheheads.config.CommonConfig;
import fuzs.alltheheads.handler.HeadBehaviorHandler;
import fuzs.alltheheads.handler.HeadLootHandler;
import fuzs.alltheheads.init.ModLootTables;
import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.context.DataPackRegistriesContext;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllTheHeads
implements ModConstructor {
    public static final String MOD_ID = "alltheheads";
    public static final String MOD_NAME = "All The Heads";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"All The Heads");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"alltheheads").common(CommonConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        AllTheHeads.registerEventHandlers();
        AllTheHeads.setupDevelopmentEnvironment();
    }

    private static void registerEventHandlers() {
        LootTableLoadCallback.EVENT.register(ModLootTables::onLootTableLoad);
        LootTableLoadCallback.EVENT.register(HeadLootHandler::onLootTableLoad);
        LivingDropsCallback.EVENT.register(HeadLootHandler::onLivingDrops);
        LivingVisibilityCallback.EVENT.register(HeadBehaviorHandler::onLivingVisibility);
    }

    private static void setupDevelopmentEnvironment() {
        if (!ModLoaderEnvironment.INSTANCE.isDevelopmentEnvironment(MOD_ID)) {
            return;
        }
        TagsUpdatedCallback.EVENT.register((registries, isClientUpdate) -> {
            if (!isClientUpdate) {
                Set mobEntities = BuiltInRegistries.ENTITY_TYPE.stream().filter(entityType -> entityType.getCategory() != MobCategory.MISC).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getResourceKey(arg_0)).mapMulti(Optional::ifPresent).collect(Collectors.toSet());
                Set headTypeEntities = registries.lookupOrThrow(ModRegistry.HEAD_REGISTRY_KEY).listElements().map(Holder.Reference::value).map(HeadType::getEntityType).distinct().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getResourceKey(arg_0)).mapMulti(Optional::ifPresent).collect(Collectors.toSet());
                Sets.difference(mobEntities, headTypeEntities).forEach(resourceKey -> LOGGER.warn("Missing head type for {}", resourceKey));
            }
        });
    }

    public void onRegisterDataPackRegistries(DataPackRegistriesContext context) {
        context.registerSyncedRegistry(ModRegistry.HEAD_REGISTRY_KEY, HeadType.DIRECT_CODEC, HeadType.DIRECT_NETWORK_CODEC);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

