/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.data.tags;

import fuzs.alltheheads.AllTheHeads;
import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagAppender;
import fuzs.puzzleslib.api.data.v2.tags.AbstractTagProvider;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootTable;

public class ModHeadTypeTagsProvider
extends AbstractTagProvider<HeadType> {
    public ModHeadTypeTagsProvider(DataProviderContext context) {
        super(ModRegistry.HEAD_REGISTRY_KEY, context);
    }

    public void addTags(HolderLookup.Provider registries) {
        AbstractTagAppender villagerLikeTagAppender = this.tag(ModRegistry.VILLAGER_LIKE_HEAD_TYPE_TAG);
        registries.lookupOrThrow(ModRegistry.HEAD_REGISTRY_KEY).listElements().forEach(headType -> {
            if (((HeadType)headType.value()).getEntityType() == EntityType.VILLAGER || ((HeadType)headType.value()).getEntityType() == EntityType.ZOMBIE_VILLAGER) {
                villagerLikeTagAppender.add(headType);
            }
        });
        registries.lookupOrThrow(ModRegistry.HEAD_REGISTRY_KEY).listElements().forEach(headType -> ModHeadTypeTagsProvider.getDefaultLootTables(((HeadType)headType.value()).getEntityTypes()).map(ModHeadTypeTagsProvider::getHeadTypeTagKey).map(arg_0 -> ((ModHeadTypeTagsProvider)this).tag(arg_0)).forEach(tagAppender -> tagAppender.add(headType)));
    }

    public static Stream<ResourceKey<LootTable>> getDefaultLootTables(Stream<EntityType<?>> stream) {
        return stream.map(EntityType::getDefaultLootTable).mapMulti(Optional::ifPresent);
    }

    public static TagKey<HeadType> getHeadTypeTagKey(ResourceKey<LootTable> resourceKey) {
        String path = resourceKey.location().toString().replace(':', '/');
        return TagKey.create(ModRegistry.HEAD_REGISTRY_KEY, (ResourceLocation)AllTheHeads.id(path));
    }
}

