/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.level.block;

import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.level.block.entity.MobHeadBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MobHeadSkullBlock
extends WallSkullBlock
implements TickingEntityBlock<MobHeadBlockEntity> {
    public MobHeadSkullBlock(BlockBehaviour.Properties properties) {
        super(ModRegistry.MOB_SKULL_BLOCK_TYPE, properties);
    }

    public BlockEntityType<? extends MobHeadBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.MOB_HEAD_BLOCK_ENTITY_TYPE.value();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        MobHeadBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof MobHeadBlockEntity && (blockEntity = (MobHeadBlockEntity)blockEntity2).getHeadType() != null) {
            return ((HeadType)blockEntity.getHeadType().value()).shape().horizontalShapes().get(state.getValue((Property)FACING));
        }
        return super.getShape(state, level, pos, context);
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return super.newBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return super.getTicker(level, state, blockEntityType);
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack itemStack = super.getCloneItemStack(level, pos, state, includeData);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MobHeadBlockEntity) {
            MobHeadBlockEntity blockEntity2 = (MobHeadBlockEntity)blockEntity;
            itemStack.applyComponents(blockEntity2.collectComponents());
        }
        return itemStack;
    }
}

