/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import com.google.common.collect.ImmutableMap;
import fuzs.alltheheads.advancements.critereon.TropicalFishPredicate;
import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.Color;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1299;
import net.minecraft.class_1474;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_7376;
import net.minecraft.class_7891;

public class TropicalFishHeadType {
    public static final class_5321<HeadType> ANEMONE = HeadTypes.register("tropical_fish/anemone");
    public static final class_5321<HeadType> BLACK_TANG = HeadTypes.register("tropical_fish/black_tang");
    public static final class_5321<HeadType> BLUE_TANG = HeadTypes.register("tropical_fish/blue_tang");
    public static final class_5321<HeadType> BUTTERFLYFISH = HeadTypes.register("tropical_fish/butterflyfish");
    public static final class_5321<HeadType> CICHLID = HeadTypes.register("tropical_fish/cichlid");
    public static final class_5321<HeadType> CLOWNFISH = HeadTypes.register("tropical_fish/clownfish");
    public static final class_5321<HeadType> COTTON_CANDY_BETTA = HeadTypes.register("tropical_fish/cotton_candy_betta");
    public static final class_5321<HeadType> DOTTYBACK = HeadTypes.register("tropical_fish/dottyback");
    public static final class_5321<HeadType> EMPEROR_RED_SNAPPER = HeadTypes.register("tropical_fish/emperor_red_snapper");
    public static final class_5321<HeadType> GOATFISH = HeadTypes.register("tropical_fish/goatfish");
    public static final class_5321<HeadType> MOORISH_IDOL = HeadTypes.register("tropical_fish/moorish_idol");
    public static final class_5321<HeadType> ORNATE_BUTTERFLYFISH = HeadTypes.register("tropical_fish/ornate_butterflyfish");
    public static final class_5321<HeadType> PARROTFISH = HeadTypes.register("tropical_fish/parrotfish");
    public static final class_5321<HeadType> QUEEN_ANGELFISH = HeadTypes.register("tropical_fish/queen_angelfish");
    public static final class_5321<HeadType> RED_CICHLID = HeadTypes.register("tropical_fish/red_cichlid");
    public static final class_5321<HeadType> RED_LIPPED_BLENNY = HeadTypes.register("tropical_fish/red_lipped_blenny");
    public static final class_5321<HeadType> RED_SNAPPER = HeadTypes.register("tropical_fish/red_snapper");
    public static final class_5321<HeadType> THREADFIN = HeadTypes.register("tropical_fish/threadfin");
    public static final class_5321<HeadType> TOMATO_CLOWNFISH = HeadTypes.register("tropical_fish/tomato_clownfish");
    public static final class_5321<HeadType> TRIGGERFISH = HeadTypes.register("tropical_fish/triggerfish");
    public static final class_5321<HeadType> YELLOWTAIL_PARROTFISH = HeadTypes.register("tropical_fish/yellowtail_parrotfish");
    public static final class_5321<HeadType> YELLOW_TANG = HeadTypes.register("tropical_fish/yellow_tang");
    private static final List<class_5321<HeadType>> COMMON_TROPICAL_FISH_VARIANTS = List.of(ANEMONE, BLACK_TANG, BLUE_TANG, BUTTERFLYFISH, CICHLID, CLOWNFISH, COTTON_CANDY_BETTA, DOTTYBACK, EMPEROR_RED_SNAPPER, GOATFISH, MOORISH_IDOL, ORNATE_BUTTERFLYFISH, PARROTFISH, QUEEN_ANGELFISH, RED_CICHLID, RED_LIPPED_BLENNY, RED_SNAPPER, THREADFIN, TOMATO_CLOWNFISH, TRIGGERFISH, YELLOWTAIL_PARROTFISH, YELLOW_TANG);
    private static final Map<class_1474.class_1475, class_2960> TROPICAL_FISH_PATTERN_TEXTURES = ImmutableMap.builder().put((Object)class_1474.class_1475.field_6881, (Object)class_2960.method_60656((String)"entity/fish/tropical_a_pattern_1")).put((Object)class_1474.class_1475.field_6880, (Object)class_2960.method_60656((String)"entity/fish/tropical_a_pattern_2")).put((Object)class_1474.class_1475.field_6882, (Object)class_2960.method_60656((String)"entity/fish/tropical_a_pattern_3")).put((Object)class_1474.class_1475.field_6890, (Object)class_2960.method_60656((String)"entity/fish/tropical_a_pattern_4")).put((Object)class_1474.class_1475.field_6891, (Object)class_2960.method_60656((String)"entity/fish/tropical_a_pattern_5")).put((Object)class_1474.class_1475.field_6892, (Object)class_2960.method_60656((String)"entity/fish/tropical_a_pattern_6")).put((Object)class_1474.class_1475.field_6893, (Object)class_2960.method_60656((String)"entity/fish/tropical_b_pattern_1")).put((Object)class_1474.class_1475.field_6887, (Object)class_2960.method_60656((String)"entity/fish/tropical_b_pattern_2")).put((Object)class_1474.class_1475.field_6883, (Object)class_2960.method_60656((String)"entity/fish/tropical_b_pattern_3")).put((Object)class_1474.class_1475.field_6884, (Object)class_2960.method_60656((String)"entity/fish/tropical_b_pattern_4")).put((Object)class_1474.class_1475.field_6888, (Object)class_2960.method_60656((String)"entity/fish/tropical_b_pattern_5")).put((Object)class_1474.class_1475.field_6889, (Object)class_2960.method_60656((String)"entity/fish/tropical_b_pattern_6")).build();

    public static void bootstrap(class_7891<HeadType> context) {
        for (int i = 0; i < COMMON_TROPICAL_FISH_VARIANTS.size(); ++i) {
            class_1474.class_7992 variant = (class_1474.class_7992)class_1474.field_41573.get(i);
            class_5321<HeadType> resourceKey = COMMON_TROPICAL_FISH_VARIANTS.get(i);
            TropicalFishHeadType.boostrapTropicalFish(context, variant, resourceKey);
        }
    }

    private static void boostrapTropicalFish(class_7891<HeadType> context, class_1474.class_7992 variant, class_5321<HeadType> resourceKey) {
        switch (variant.comp_1177().method_47867()) {
            case field_41575: {
                TropicalFishHeadType.boostrapTropicalFish(context, variant, resourceKey, "entity/fish/tropical_b", new Shape(2.0, 6.0, 4.0), ModelType.TROPICAL_FISH_LARGE);
                break;
            }
            case field_41574: {
                TropicalFishHeadType.boostrapTropicalFish(context, variant, resourceKey, "entity/fish/tropical_a", new Shape(2.0, 3.0, 4.0), ModelType.TROPICAL_FISH_SMALL);
            }
        }
    }

    private static void boostrapTropicalFish(class_7891<HeadType> context, class_1474.class_7992 variant, class_5321<HeadType> resourceKey, String textureLocation, Shape shape, ModelType modelType) {
        HeadType.builder(class_1299.field_6111).entityPredicate(builder -> builder.method_43094((class_7376)TropicalFishPredicate.hasVariant(variant))).shape(shape).scale(1.5).dyedModel(modelType, ResourceLocationHelper.withDefaultNamespace((String)textureLocation), new Color.Dye(variant.comp_1178())).dyedModel(modelType, TROPICAL_FISH_PATTERN_TEXTURES.get(variant.comp_1177()), new Color.Dye(variant.comp_1179())).noteBlockSound(class_3417.field_14878).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<class_5321<HeadType>, String> translationConsumer) {
        translationConsumer.accept(ANEMONE, "Anemone Head");
        translationConsumer.accept(BLACK_TANG, "Black Tang Head");
        translationConsumer.accept(BLUE_TANG, "Blue Tang Head");
        translationConsumer.accept(BUTTERFLYFISH, "Butterflyfish Head");
        translationConsumer.accept(CICHLID, "Cichlid Head");
        translationConsumer.accept(CLOWNFISH, "Clownfish Head");
        translationConsumer.accept(COTTON_CANDY_BETTA, "Cotton Candy Betta Head");
        translationConsumer.accept(DOTTYBACK, "Dottyback Head");
        translationConsumer.accept(EMPEROR_RED_SNAPPER, "Emperor Red Snapper Head");
        translationConsumer.accept(GOATFISH, "Goatfish Head");
        translationConsumer.accept(MOORISH_IDOL, "Moorish Idol Head");
        translationConsumer.accept(ORNATE_BUTTERFLYFISH, "Ornate Butterflyfish Head");
        translationConsumer.accept(PARROTFISH, "Parrotfish Head");
        translationConsumer.accept(QUEEN_ANGELFISH, "Queen Angelfish Head");
        translationConsumer.accept(RED_CICHLID, "Red Cichlid Head");
        translationConsumer.accept(RED_LIPPED_BLENNY, "Red Lipped Blenny Head");
        translationConsumer.accept(RED_SNAPPER, "Red Snapper Head");
        translationConsumer.accept(THREADFIN, "Threadfin Head");
        translationConsumer.accept(TOMATO_CLOWNFISH, "Tomato Clownfish Head");
        translationConsumer.accept(TRIGGERFISH, "Triggerfish Head");
        translationConsumer.accept(YELLOWTAIL_PARROTFISH, "Yellowtail Parrotfish Head");
        translationConsumer.accept(YELLOW_TANG, "Yellow Tang Head");
    }
}

