/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import net.mehvahdjukaar.moonlight.api.client.CoreShaderContainer;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.client.LiveFeedRendererManager;
import net.mehvahdjukaar.vista.client.TvBlockEntityRenderer;
import net.mehvahdjukaar.vista.client.TvItemRenderer;
import net.mehvahdjukaar.vista.client.ViewFinderBlockEntityRenderer;
import net.mehvahdjukaar.vista.client.ViewFinderController;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.mehvahdjukaar.vista.configs.ClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VistaModClient {
    public static final CoreShaderContainer POSTERIZE_SHADER = new CoreShaderContainer(GameRenderer::getPositionTexColorShader);
    public static final CoreShaderContainer CAMERA_VIEW_SHADER = new CoreShaderContainer(GameRenderer::getRendertypeEntitySolidShader);
    public static final CoreShaderContainer STATIC_SHADER = new CoreShaderContainer(GameRenderer::getPositionColorShader);
    public static final ModelLayerLocation VIEWFINDER_MODEL = VistaModClient.loc("viewfinder");
    public static final Material VIEW_FINDER_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, VistaMod.res("block/viewfinder"));
    private static boolean preventShiftTillNextKeyUp = false;

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(VistaMod.res(name), name);
    }

    public static void init() {
        ClientConfigs.init();
        ClientHelper.addBlockEntityRenderersRegistration(VistaModClient::registerBlockEntityRenderers);
        ClientHelper.addShaderRegistration(VistaModClient::registerShaders);
        ClientHelper.addModelLayerRegistration(VistaModClient::registerModelLayers);
        ClientHelper.addItemColorsRegistration(VistaModClient::registerItemColors);
        ClientHelper.addItemRenderersRegistration(VistaModClient::registerItemRenderers);
    }

    private static void registerItemRenderers(ClientHelper.ItemRendererEvent event) {
        event.register((ItemLike)VistaMod.TV_ITEM.get(), (ItemStackRenderer)new TvItemRenderer());
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        event.register((itemStack, i) -> {
            if (i == 1) {
                Holder tape = (Holder)itemStack.get(VistaMod.CASSETTE_TAPE_COMPONENT.get());
                if (tape == null) {
                    return -1;
                }
                return ((CassetteTape)tape.value()).color();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)VistaMod.CASSETTE.get()});
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(VistaMod.TV_TILE.get(), TvBlockEntityRenderer::new);
        event.register(VistaMod.VIEWFINDER_TILE.get(), ViewFinderBlockEntityRenderer::new);
    }

    private static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(VistaMod.res("static_noise"), DefaultVertexFormat.NEW_ENTITY, arg_0 -> ((CoreShaderContainer)STATIC_SHADER).assign(arg_0));
        event.register(VistaMod.res("camera_view"), DefaultVertexFormat.NEW_ENTITY, arg_0 -> ((CoreShaderContainer)CAMERA_VIEW_SHADER).assign(arg_0));
        event.register(VistaMod.res("posterize"), DefaultVertexFormat.POSITION_TEX, arg_0 -> ((CoreShaderContainer)POSTERIZE_SHADER).assign(arg_0));
    }

    private static void registerModelLayers(ClientHelper.ModelLayerEvent event) {
        event.register(VIEWFINDER_MODEL, ViewFinderBlockEntityRenderer::createMesh);
    }

    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public static void onLevelClose() {
        LiveFeedRendererManager.clear();
    }

    public static void onClientTick(Minecraft minecraft) {
        if (minecraft.isPaused() || minecraft.level == null) {
            return;
        }
        LocalPlayer p = minecraft.player;
        if (p == null) {
            return;
        }
        ViewFinderController.onClientTick(minecraft);
    }

    public static void modifyInputUpdate(Input instance, LocalPlayer player) {
        if (ViewFinderController.isActive()) {
            ViewFinderController.onInputUpdate(instance);
            preventShiftTillNextKeyUp = true;
        } else if (preventShiftTillNextKeyUp) {
            if (!instance.shiftKeyDown) {
                preventShiftTillNextKeyUp = false;
            } else {
                instance.shiftKeyDown = false;
            }
        }
    }
}

