/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.client.ModRenderTypes;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class TapeTextureManager {
    public static final ResourceLocation ATLAS_LOCATION = VistaMod.res("textures/atlas/cassette_tape.png");
    public static final ResourceLocation ATLAS_INFO_LOCATION = VistaMod.res("cassette_tapes");
    private static final ResourceLocation BARS_LOCATION = VistaMod.res("color_bars");
    private static final ResourceLocation SMILE_LOCATION = VistaMod.res("smile");
    private static final ResourceLocation NEUTRAL_LOCATION = VistaMod.res("neutral");
    private static final ResourceLocation SAD_LOCATION = VistaMod.res("sad");
    private static final Map<ResourceKey<CassetteTape>, Material> MATERIALS = new HashMap<ResourceKey<CassetteTape>, Material>();
    private static final Map<ResourceKey<CassetteTape>, Material> MATERIALS_FLAT = new HashMap<ResourceKey<CassetteTape>, Material>();
    private static final Material DEFAULT_MATERIAL = new Material(ATLAS_LOCATION, BARS_LOCATION);
    private static final Material DEFAULT_MATERIAL_FLAT = new Material(ATLAS_LOCATION, BARS_LOCATION);
    private static final Material SMILE_MATERIAL = new Material(ATLAS_LOCATION, SMILE_LOCATION);
    private static final Material SMILE_MATERIAL_FLAT = new Material(ATLAS_LOCATION, SMILE_LOCATION);
    private static final Material NEUTRAL_MATERIAL = new Material(ATLAS_LOCATION, NEUTRAL_LOCATION);
    private static final Material NEUTRAL_MATERIAL_FLAT = new Material(ATLAS_LOCATION, NEUTRAL_LOCATION);
    private static final Material SAD_MATERIAL = new Material(ATLAS_LOCATION, SAD_LOCATION);
    private static final Material SAD_MATERIAL_FLAT = new Material(ATLAS_LOCATION, SAD_LOCATION);

    public static Material getMaterial(Holder<CassetteTape> tapeKey) {
        return MATERIALS.computeIfAbsent((ResourceKey<CassetteTape>)((ResourceKey)tapeKey.unwrapKey().get()), k -> new Material(ATLAS_LOCATION, ((CassetteTape)tapeKey.value()).assetId()));
    }

    public static Material getMaterialFlat(Holder<CassetteTape> tapeKey) {
        return MATERIALS_FLAT.computeIfAbsent((ResourceKey<CassetteTape>)((ResourceKey)tapeKey.unwrapKey().get()), k -> new Material(ATLAS_LOCATION, ((CassetteTape)tapeKey.value()).assetId()));
    }

    public static VertexConsumer getTapeVC(Holder<CassetteTape> tapeKey, MultiBufferSource buffer, boolean flat) {
        Material mat = flat ? TapeTextureManager.getMaterialFlat(tapeKey) : TapeTextureManager.getMaterial(tapeKey);
        return mat.buffer(buffer, !flat ? t -> ModRenderTypes.CAMERA_DRAW_SPRITE.apply((ResourceLocation)t, mat) : RenderType::text);
    }

    public static VertexConsumer getDefaultTapeVC(MultiBufferSource buffer, boolean flat) {
        Material mat = flat ? DEFAULT_MATERIAL_FLAT : DEFAULT_MATERIAL;
        return mat.buffer(buffer, !flat ? t -> ModRenderTypes.CAMERA_DRAW_SPRITE.apply((ResourceLocation)t, mat) : RenderType::text);
    }

    public static VertexConsumer getSmileTapeVC(MultiBufferSource buffer, LivingEntity player, boolean flat) {
        float health = player.getHealth() / player.getMaxHealth();
        Material mat = health > 0.66f ? (flat ? SMILE_MATERIAL_FLAT : SMILE_MATERIAL) : (health > 0.33f ? (flat ? NEUTRAL_MATERIAL_FLAT : NEUTRAL_MATERIAL) : (flat ? SAD_MATERIAL_FLAT : SAD_MATERIAL));
        return mat.buffer(buffer, !flat ? t -> ModRenderTypes.CAMERA_DRAW_SPRITE.apply((ResourceLocation)t, mat) : RenderType::text);
    }

    public static VertexConsumer getFullSpriteVC(ResourceLocation tex, MultiBufferSource buffer, boolean flat) {
        RenderType rt = !flat ? ModRenderTypes.CAMERA_DRAW.apply(tex) : RenderType.text((ResourceLocation)tex);
        return buffer.getBuffer(rt);
    }

    public static void onWorldReload() {
        MATERIALS.clear();
        MATERIALS_FLAT.clear();
    }
}

