/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.client.LiveFeedRendererManager;
import net.mehvahdjukaar.vista.client.ModRenderTypes;
import net.mehvahdjukaar.vista.client.TapeTextureManager;
import net.mehvahdjukaar.vista.common.CassetteTape;
import net.mehvahdjukaar.vista.common.TVBlock;
import net.mehvahdjukaar.vista.common.TVBlockEntity;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompatClient;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class TvBlockEntityRenderer
implements BlockEntityRenderer<TVBlockEntity> {
    private static final int SCREEN_RESOLUTION_SCALE = 8;

    public TvBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TVBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        ResourceLocation texture;
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)TVBlock.POWERED)).booleanValue()) {
            return;
        }
        boolean drawingCamera = LiveFeedRendererManager.LIVE_FEED_BEING_RENDERED != null;
        VertexConsumer vc = null;
        int screenPixelSize = blockEntity.getScreenPixelSize();
        UUID liveFeedId = blockEntity.getLinkedFeedUUID();
        Holder<CassetteTape> tape = blockEntity.getTape();
        ItemStack stack = blockEntity.getDisplayedItem();
        if (liveFeedId != null) {
            ResourceLocation tex = LiveFeedRendererManager.requestLiveFeedTexture(blockEntity.getLevel(), liveFeedId, screenPixelSize * 8);
            vc = tex != null ? TapeTextureManager.getFullSpriteVC(tex, buffer, drawingCamera) : TapeTextureManager.getDefaultTapeVC(buffer, drawingCamera);
        } else if (tape != null) {
            if (drawingCamera) {
                mat = TapeTextureManager.getMaterialFlat(tape);
                vc = mat.buffer(buffer, RenderType::text);
            } else {
                mat = TapeTextureManager.getMaterial(tape);
                vc = mat.buffer(buffer, t -> ModRenderTypes.CAMERA_DRAW_SPRITE.apply((ResourceLocation)t, mat));
            }
        } else if (VistaMod.EXPOSURE_ON && (texture = ExposureCompatClient.getPictureTextureForRenderer(stack, blockEntity.getAnimationTick())) != null) {
            vc = TapeTextureManager.getFullSpriteVC(texture, buffer, drawingCamera);
        }
        if (vc == null) {
            vc = buffer.getBuffer(ModRenderTypes.NOISE);
        }
        Direction dir = (Direction)blockEntity.getBlockState().getValue((Property)TVBlock.FACING);
        float yaw = dir.toYRot();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.translate(-0.5, -0.5, -0.5);
        light = 0xF000F0;
        float s = (float)screenPixelSize / 32.0f;
        poseStack.translate(0.5, 0.5, -0.001);
        int lightU = light & 0xFFFF;
        int lightV = light >> 16 & 0xFFFF;
        VertexUtil.addQuad((VertexConsumer)vc, (PoseStack)poseStack, (float)(-s), (float)(-s), (float)s, (float)s, (int)lightU, (int)lightV);
    }
}

