/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.vista.VistaModClient;
import net.mehvahdjukaar.vista.client.ViewFinderController;
import net.mehvahdjukaar.vista.common.ViewFinderBlock;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ViewFinderBlockEntityRenderer
implements BlockEntityRenderer<ViewFinderBlockEntity> {
    private final ModelPart head;
    private final ModelPart legs;
    private final ModelPart pivot;
    private final ModelPart model;

    public ViewFinderBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.bakeLayer(VistaModClient.VIEWFINDER_MODEL);
        this.legs = model.getChild("legs");
        this.pivot = this.legs.getChild("head_pivot");
        this.head = this.pivot.getChild("head");
        this.model = model;
    }

    public int getViewDistance() {
        return 96;
    }

    public void render(ViewFinderBlockEntity tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        this.renderModel(tile, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void renderModel(ViewFinderBlockEntity tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        boolean isControlledByLocalInstance = ViewFinderController.isActive() && ViewFinderController.access.getInternalTile() == tile;
        poseStack.pushPose();
        Quaternionf rotation = ((Direction)tile.getBlockState().getValue((Property)ViewFinderBlock.FACING)).getOpposite().getRotation();
        poseStack.mulPose(rotation);
        VertexConsumer builder = VistaModClient.VIEW_FINDER_MATERIAL.buffer(bufferSource, RenderType::entityCutout);
        float pitchRad = tile.getPitch(partialTick) * ((float)Math.PI / 180);
        float yawRad = tile.getYaw(partialTick) * ((float)Math.PI / 180);
        Vector3f forward = new Vector3f(0.0f, 0.0f, 1.0f);
        forward.rotateX((float)Math.PI - pitchRad);
        forward.rotateY((float)Math.PI - yawRad);
        forward.rotate((Quaternionfc)rotation.invert());
        yawRad = (float)Mth.atan2((double)forward.x, (double)forward.z);
        pitchRad = (float)Mth.atan2((double)(-forward.y), (double)Mth.sqrt((float)(forward.x * forward.x + forward.z * forward.z)));
        this.legs.yRot = yawRad;
        this.pivot.xRot = pitchRad;
        this.pivot.zRot = 0.0f;
        this.legs.visible = !isControlledByLocalInstance;
        this.head.visible = !isControlledByLocalInstance;
        this.model.render(poseStack, builder, packedLight, packedOverlay);
        poseStack.mulPose(Axis.YP.rotation(yawRad));
        poseStack.mulPose(Axis.XP.rotation(pitchRad));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.translate(0.25, 0.5, 0.25);
        ItemStack stack = Items.CREEPER_HEAD.getDefaultInstance();
        poseStack.popPose();
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition legs = partdefinition.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(0, 36).addBox(5.0f, -4.0f, -2.0f, 2.0f, 10.0f, 4.0f).texOffs(12, 36).addBox(-7.0f, -4.0f, -2.0f, 2.0f, 10.0f, 4.0f), PartPose.ZERO);
        PartDefinition head = legs.addOrReplaceChild("head_pivot", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bone = head.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, -6.0f, -4.0f, 10.0f, 12.0f, 8.0f), PartPose.ZERO);
        PartDefinition base = partdefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, 6.0f, -7.0f, 14.0f, 2.0f, 14.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

