/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.vista.VistaMod;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CassetteItem
extends Item {
    public CassetteItem(Item.Properties properties) {
        super(properties);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return super.getTooltipImage(stack);
    }

    public void onCraftedPostProcess(ItemStack stack, Level level) {
        super.onCraftedPostProcess(stack, level);
        CassetteItem.assignCustomCassette(stack, level);
    }

    public static void assignCustomCassette(ItemStack stack, Level level) {
        Component customName = (Component)stack.get(DataComponents.CUSTOM_NAME);
        if (customName != null) {
            String name = customName.getString().toLowerCase(Locale.ROOT);
            CassetteItem.assignCustomCassette(stack, level, name);
        }
    }

    public static void assignCustomCassette(ItemStack stack, Level level, String name) {
        for (Holder h : level.registryAccess().registryOrThrow(VistaMod.CASSETTE_TAPE_REGISTRY_KEY).getTagOrEmpty(VistaMod.SUPPORTER_TAPES)) {
            ResourceKey key = (ResourceKey)h.unwrapKey().get();
            if (!key.location().getPath().equals(name)) continue;
            stack.set(VistaMod.CASSETTE_TAPE_COMPONENT.get(), (Object)h);
            stack.remove(DataComponents.CUSTOM_NAME);
            break;
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Holder tape = (Holder)stack.get(VistaMod.CASSETTE_TAPE_COMPONENT.get());
        if (tape != null) {
            tape.unwrapKey().ifPresent(resourceKey -> {
                ResourceLocation location = resourceKey.location();
                if (tape.is(VistaMod.SUPPORTER_TAPES)) {
                    tooltipComponents.add((Component)Component.literal((String)LangBuilder.getReadableName((String)location.getPath())).withStyle(ChatFormatting.GRAY));
                } else {
                    tooltipComponents.add((Component)Component.translatable((String)location.toLanguageKey("cassette_tape", "tooltip")).withStyle(ChatFormatting.GRAY));
                }
            });
        }
    }
}

