/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.common.TVBlockEntity;
import net.mehvahdjukaar.vista.common.TvConnection;
import net.mehvahdjukaar.vista.common.TvHelper;
import net.mehvahdjukaar.vista.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TVBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
Equipable {
    public static final MapCodec<TVBlock> CODEC = TVBlock.simpleCodec(TVBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<TvConnection> CONNECTION = EnumProperty.create((String)"connection", TvConnection.class);

    public TVBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Boolean)state.getValue((Property)POWERED) != false ? 3 : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(CONNECTION, (Comparable)((Object)TvConnection.NONE))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
        builder.add(new Property[]{CONNECTION});
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return !level.isClientSide ? null : Utils.getTicker(blockEntityType, VistaMod.TV_TILE.get(), TVBlockEntity::clientTick);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        BlockState neighborState;
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        boolean powered = level.hasNeighborSignal(pos);
        if (neighborBlock == this && TVBlock.facingSameDir(neighborState = level.getBlockState(neighborPos), state) && ((TvConnection)((Object)state.getValue(CONNECTION))).isConnected((TvConnection)((Object)neighborState.getValue(CONNECTION)))) {
            powered |= ((Boolean)neighborState.getValue((Property)POWERED)).booleanValue();
        }
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            if (powered) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private static boolean facingSameDir(BlockState neighborState, BlockState state) {
        return neighborState.getValue((Property)FACING) == state.getValue((Property)FACING);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (!state.is(oldState.getBlock())) {
            this.updateAllConnections(state, level, pos);
        }
    }

    @Nullable
    private TVBlockEntity getMasterBlockEntity(Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof TVBlockEntity) {
            TVBlockEntity tv = (TVBlockEntity)be;
            return tv;
        }
        return null;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean powered = context.getLevel().hasNeighborSignal(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TVBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TVBlockEntity) {
            TVBlockEntity tile = (TVBlockEntity)blockEntity;
            return tile.interactWithPlayerItem(player, hand, stack);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void updateAllConnections(BlockState state, Level level, BlockPos pos) {
        if (!CommonConfigs.CONNECTED_TVS.get().booleanValue()) {
            return;
        }
        TVGridAccess gridAccess = new TVGridAccess(level, pos, state);
        TvHelper.updateConnections(gridAccess);
        gridAccess.applyChanges();
    }

    @Deprecated(forRemoval=true)
    public static BlockPos relativePos(BlockPos pos, Direction normal, int left, int top, int forward) {
        Preconditions.checkArgument((normal.getAxis() != Direction.Axis.Y ? 1 : 0) != 0, (Object)"Normal direction cannot be vertical");
        if (forward != 0) {
            pos = pos.relative(normal, forward);
        }
        if (left != 0) {
            Direction leftDir = normal.getCounterClockWise();
            pos = pos.relative(leftDir, left);
        }
        if (top != 0) {
            pos = pos.above(top);
        }
        return pos;
    }

    public static class TVGridAccess
    implements TvHelper.GridAccess {
        private final BlockPos pos;
        private final Direction facing;
        private final Level level;
        private final Map<Vec2i, TvConnection> statesCache = new HashMap<Vec2i, TvConnection>();
        private final Map<Vec2i, TvConnection> statesChanged = new HashMap<Vec2i, TvConnection>();

        public TVGridAccess(Level level, BlockPos pos, BlockState state) {
            this.pos = pos;
            this.facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
            this.level = level;
        }

        @Override
        @Nullable
        public TvConnection get(int left, int top) {
            Vec2i key = new Vec2i(left, top);
            if (this.statesChanged.containsKey(key)) {
                return this.statesChanged.get(key);
            }
            BlockPos target = TVBlock.relativePos(this.pos, this.facing, left, top, 0);
            BlockState bs = this.level.getBlockState(target);
            TvConnection value = null;
            if (bs.getBlock() instanceof TVBlock && bs.getValue((Property)HorizontalDirectionalBlock.FACING) == this.facing) {
                value = (TvConnection)((Object)bs.getValue(CONNECTION));
            }
            this.statesCache.put(key, value);
            return value;
        }

        @Override
        public void set(int left, int top, @Nullable TvConnection state) {
            Vec2i key = new Vec2i(left, top);
            TvConnection old = this.statesCache.get(key);
            if (old != state) {
                this.statesChanged.put(key, state);
            }
        }

        public void applyChanges() {
            for (Map.Entry<Vec2i, TvConnection> e : this.statesChanged.entrySet()) {
                Vec2i key = e.getKey();
                TvConnection conn = e.getValue();
                BlockPos target = TVBlock.relativePos(this.pos, this.facing, key.x, key.y, 0);
                BlockState bs = this.level.getBlockState(target);
                if (!(bs.getBlock() instanceof TVBlock) || conn == null) continue;
                this.level.setBlockAndUpdate(target, (BlockState)bs.setValue(CONNECTION, (Comparable)((Object)conn)));
            }
        }
    }

    private record Vec2i(int x, int y) {
    }
}

