/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;

public enum TvConnection implements StringRepresentable
{
    NONE(0),
    CENTER(15),
    TOP(14),
    BOTTOM(13),
    LEFT(11),
    RIGHT(7),
    TOP_LEFT(10),
    TOP_RIGHT(6),
    BOTTOM_LEFT(9),
    BOTTOM_RIGHT(5);

    private final int mask;

    private TvConnection(int mask) {
        this.mask = mask;
        F.LUT[mask] = this;
    }

    public static TvConnection get(boolean up, boolean down, boolean left, boolean right) {
        int mask = (up ? 1 : 0) | (down ? 2 : 0) | (left ? 4 : 0) | (right ? 8 : 0);
        TvConnection c = F.LUT[mask];
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException("Invalid pattern for square tiling (mask=" + mask + ")");
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isConnected(TvConnection other) {
        if (other == null) {
            return false;
        }
        return (this.mask & other.mask) != 0;
    }

    private static class F {
        private static final int U = 1;
        private static final int D = 2;
        private static final int L = 4;
        private static final int R = 8;
        private static final TvConnection[] LUT = new TvConnection[16];

        private F() {
        }
    }
}

