/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.common;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOnePlayerInteractable;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.common.ViewFinderAccess;
import net.mehvahdjukaar.vista.common.ViewFinderConnection;
import net.mehvahdjukaar.vista.network.ClientBoundControlViewFinderPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ViewFinderBlockEntity
extends ItemDisplayTile
implements IOnePlayerInteractable {
    public Object ccHack = null;
    private final ViewFinderAccess selfAccess;
    private UUID myUUID = UUID.randomUUID();
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private int zoom = 1;
    private boolean locked = false;
    @Nullable
    private UUID controllingPlayer = null;

    public ViewFinderBlockEntity(BlockPos pos, BlockState state) {
        super(VistaMod.VIEWFINDER_TILE.get(), pos, state);
        this.selfAccess = ViewFinderAccess.block(this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ViewFinderBlockEntity tile) {
        tile.prevYaw = tile.yaw;
        tile.prevPitch = tile.pitch;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.updateLink();
    }

    private void updateLink() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ViewFinderConnection.get((Level)sl).linkFeed(this.myUUID, new GlobalPos(this.level.dimension(), this.worldPosition));
        }
    }

    private void removeLink() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            ViewFinderConnection.get((Level)sl).unlinkFeed(this.myUUID);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.myUUID = tag.getUUID("UUID");
        this.yaw = tag.getFloat("yaw");
        this.pitch = tag.getFloat("pitch");
        this.locked = tag.getBoolean("locked");
        this.zoom = tag.getInt("zoom");
        this.updateLink();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putUUID("UUID", this.myUUID);
        tag.putFloat("yaw", this.yaw);
        tag.putFloat("pitch", this.pitch);
        tag.putBoolean("locked", this.locked);
        tag.putInt("zoom", this.zoom);
    }

    protected Component getDefaultName() {
        return Component.literal((String)"View Finder");
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        BlockItem bi;
        Item item = stack.getItem();
        return item instanceof BlockItem && ((bi = (BlockItem)item).getBlock() instanceof StainedGlassPaneBlock || bi.getBlock() instanceof SkullBlock);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public ItemInteractionResult tryInteracting(Player player, InteractionHand hand, ItemStack stack, BlockPos pos) {
        ItemInteractionResult itemAdd = this.interactWithPlayerItem(player, hand, stack);
        if (itemAdd.consumesAction()) {
            return itemAdd;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (!this.isOtherPlayerEditing(pos, player)) {
                this.setPlayerWhoMayEdit(player.getUUID());
                NetworkHelper.sendToClientPlayer((ServerPlayer)sp, (CustomPacketPayload)new ClientBoundControlViewFinderPacket(TileOrEntityTarget.of((BlockEntity)this)));
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public UUID getUUID() {
        return this.myUUID;
    }

    public float getYaw(float partialTicks) {
        return Mth.rotLerp((float)partialTicks, (float)this.prevYaw, (float)this.yaw);
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch(float partialTicks) {
        return Mth.rotLerp((float)partialTicks, (float)this.prevPitch, (float)this.pitch);
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getZoomLevel() {
        return this.zoom;
    }

    public int getMaxZoom() {
        return 44;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setAttributes(float yaw, float pitch, int zoom, boolean locked, Player controllingPlayer, ViewFinderAccess access) {
        this.setYaw(access, yaw);
        this.setPitch(access, pitch);
        this.zoom = zoom;
        this.locked = locked;
    }

    public void setZoomLevel(int zoom) {
        this.zoom = zoom;
    }

    public void setPitch(ViewFinderAccess access, float relativePitch) {
        ViewFinderAccess.Restraint r = access.getPitchAndYawRestrains();
        this.pitch = MthUtils.clampDegrees((float)relativePitch, (float)r.minPitch(), (float)r.maxPitch());
    }

    public void setYaw(ViewFinderAccess access, float relativeYaw) {
        ViewFinderAccess.Restraint r = access.getPitchAndYawRestrains();
        this.yaw = MthUtils.clampDegrees((float)relativeYaw, (float)r.minYaw(), (float)r.maxYaw());
    }

    public void setGlobalYaw(ViewFinderAccess access, float relativeYaw) {
        float yawOffset = access.getCannonGlobalYawOffset(1.0f);
        this.setYaw(access, relativeYaw);
    }

    public void setRenderYaw(ViewFinderAccess access, float relativeYaw) {
        this.setYaw(access, relativeYaw);
        this.prevYaw = this.yaw;
    }

    public void setRenderPitch(ViewFinderAccess access, float pitch) {
        this.setPitch(access, pitch);
        this.prevPitch = this.pitch;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }

    public void setPlayerWhoMayEdit(@Nullable UUID uuid) {
        this.controllingPlayer = uuid;
    }

    public UUID getPlayerWhoMayEdit() {
        return this.controllingPlayer;
    }

    public float getModifiedFOV(float startingFov, float modFov) {
        float spyglassZoom = 0.1f;
        float maxZoom = spyglassZoom / 5.0f;
        float normalizedZoom = this.getNormalizedZoomFactor();
        return Mth.lerp((float)normalizedZoom, (float)1.0f, (float)maxZoom);
    }

    public float getNormalizedZoomFactor() {
        float normalizedZoom = ((float)this.getZoomLevel() - 1.0f) / ((float)this.getMaxZoom() - 1.0f);
        normalizedZoom = 1.0f - (1.0f - normalizedZoom) * (1.0f - normalizedZoom);
        return normalizedZoom;
    }
}

