/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.integration.exposure;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.world.inventory.slot.AlbumPhotographSlot;
import io.github.mortuusars.exposure.world.inventory.slot.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.vista.integration.exposure.ExposureCompat;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeContent;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PictureTapeMenu
extends AbstractContainerMenu {
    public static final int CANCEL_ADDING_PHOTO_BUTTON = -1;
    public static final int PREVIOUS_PAGE_BUTTON = PagingDirection.PREVIOUS.ordinal();
    public static final int NEXT_PAGE_BUTTON = PagingDirection.NEXT.ordinal();
    public static final int PAGE_PHOTO_BUTTON = 2;
    protected final int pictureTapeSlot;
    protected final ItemStack pictureTape;
    protected final List<ItemStack> photographSlots = new ArrayList<ItemStack>();
    protected final List<AlbumPlayerInventorySlot> playerInventorySlots = new ArrayList<AlbumPlayerInventorySlot>();
    protected DataSlot currentIndex = DataSlot.standalone();
    protected boolean isAddingPhotograph = false;
    protected final Map<Integer, Consumer<Player>> buttonActions = new HashMap<Integer, Consumer<Player>>(){
        {
            this.put(-1, p -> {
                PictureTapeMenu.this.isAddingPhotograph = false;
                if (!PictureTapeMenu.this.getCarried().isEmpty()) {
                    p.getInventory().placeItemBackInInventory(PictureTapeMenu.this.getCarried());
                    PictureTapeMenu.this.setCarried(ItemStack.EMPTY);
                }
                PictureTapeMenu.this.updatePlayerInventorySlots();
            });
            this.put(PREVIOUS_PAGE_BUTTON, p -> {
                PictureTapeMenu.this.clickMenuButton((Player)p, -1);
                PictureTapeMenu.this.setCurrentSpreadIndex(Math.max(0, PictureTapeMenu.this.getCurrentIndex() - 1));
            });
            this.put(NEXT_PAGE_BUTTON, p -> {
                PictureTapeMenu.this.clickMenuButton((Player)p, -1);
                PictureTapeMenu.this.setCurrentSpreadIndex(Math.min((PictureTapeMenu.this.getTapeContent().size() - 1) / 2, PictureTapeMenu.this.getCurrentIndex() + 1));
            });
            this.put(2, p -> PictureTapeMenu.this.onPhotoButtonPress((Player)p));
        }
    };

    public static PictureTapeMenu fromBuffer(int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new PictureTapeMenu(containerId, playerInventory, buffer.readVarInt());
    }

    public PictureTapeMenu(int containerId, Inventory playerInventory, int albumSlot) {
        this(ExposureCompat.PICTURE_TAPE_MENU.get(), containerId, playerInventory, albumSlot);
    }

    protected PictureTapeMenu(MenuType<? extends AbstractContainerMenu> type, int containerId, Inventory playerInventory, int albumSlot) {
        super(type, containerId);
        this.pictureTapeSlot = albumSlot;
        this.pictureTape = playerInventory.getItem(albumSlot);
        if (!(this.pictureTape.getItem() instanceof PictureTapeItem)) {
            throw new IllegalStateException("Expected PictureTapeItem in slot '" + albumSlot + "'. Got: " + String.valueOf(this.pictureTape));
        }
        this.addPhotographSlots();
        this.addPlayerInventorySlots(playerInventory, 70, 115);
        this.addDataSlot(this.currentIndex);
    }

    protected void addPhotographSlots() {
        PictureTapeContent content = PictureTapeItem.getContent(this.pictureTape);
        this.photographSlots.addAll(content.pictures().toList());
        this.photographSlots.add(ItemStack.EMPTY);
        ItemStack[] photographs = (ItemStack[])content.pictures().toArray(ItemStack[]::new);
        SimpleContainer container = new SimpleContainer(photographs);
        for (int i = 0; i < container.getContainerSize(); ++i) {
            int x = i % 2 == 0 ? 71 : 212;
            int y = 67;
            AlbumPhotographSlot slot = new AlbumPhotographSlot((Container)container, i, x, y){

                public void set(ItemStack stack) {
                    super.set(stack);
                    PictureTapeMenu.this.onPhotographSlotChanged(this.getContainerSlot(), stack);
                }
            };
            this.addSlot((Slot)slot);
        }
    }

    private void onPhotographSlotChanged(int slotIndex, ItemStack stack) {
        PictureTapeItem.setPictureAtIndex(this.pictureTape, slotIndex, stack);
    }

    private void addPlayerInventorySlots(Inventory playerInventory, int x, int y) {
        AlbumPlayerInventorySlot slot;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                slot = new AlbumPlayerInventorySlot((Container)playerInventory, column + row * 9 + 9, x + column * 18, y + row * 18);
                this.addSlot((Slot)slot);
                this.playerInventorySlots.add(slot);
            }
        }
        for (int index = 0; index < 9; ++index) {
            final boolean disabled = index == playerInventory.selected && playerInventory.getSelected().getItem() instanceof PictureTapeItem;
            slot = new AlbumPlayerInventorySlot(this, (Container)playerInventory, index, x + index * 18, y + 58){

                public boolean mayPickup(Player player) {
                    return !disabled;
                }

                public boolean mayPlace(ItemStack stack) {
                    return !disabled;
                }
            };
            this.addSlot((Slot)slot);
            this.playerInventorySlots.add(slot);
        }
    }

    protected void updatePlayerInventorySlots() {
        boolean isInAddingPhotographMode = this.isInAddingPhotographMode();
        for (AlbumPlayerInventorySlot slot : this.playerInventorySlots) {
            slot.setActive(isInAddingPhotographMode);
        }
    }

    public int getAlbumSlot() {
        return this.pictureTapeSlot;
    }

    public boolean isInAddingPhotographMode() {
        return this.isAddingPhotograph;
    }

    public List<AlbumPlayerInventorySlot> getPlayerInventorySlots() {
        return this.playerInventorySlots;
    }

    public PictureTapeContent getTapeContent() {
        return PictureTapeItem.getContent(this.pictureTape);
    }

    public Optional<ItemStack> getPictureAtIndex(int pageIndex) {
        PictureTapeContent content = this.getTapeContent();
        if (pageIndex <= content.size() - 1) {
            return Optional.ofNullable(content.getPicture(pageIndex));
        }
        return Optional.empty();
    }

    public Optional<ItemStack> getPictureAtIndex() {
        return this.getPictureAtIndex(this.getCurrentIndex());
    }

    public Optional<AlbumPhotographSlot> getCurrentPhotograph() {
        return this.getCurrentPhotograph(this.getCurrentIndex());
    }

    public Optional<AlbumPhotographSlot> getCurrentPhotograph(int index) {
        if (index >= 0 && index < this.photographSlots.size()) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public ItemStack getPhotograph() {
        return this.getCurrentPhotograph().map(Slot::getItem).orElse(ItemStack.EMPTY);
    }

    public int getCurrentIndex() {
        return this.currentIndex.get();
    }

    public void setCurrentSpreadIndex(int spreadIndex) {
        this.currentIndex.set(spreadIndex);
    }

    public boolean clickMenuButton(Player player, int id) {
        @Nullable Consumer<Player> buttonAction = this.buttonActions.get(id);
        if (buttonAction != null) {
            buttonAction.accept(player);
            return true;
        }
        return false;
    }

    private void onPhotoButtonPress(Player player) {
        Optional<AlbumPhotographSlot> photographSlot = this.getCurrentPhotograph();
        if (photographSlot.isEmpty()) {
            return;
        }
        AlbumPhotographSlot slot = photographSlot.get();
        if (!slot.hasItem()) {
            this.isAddingPhotograph = true;
        } else {
            ItemStack stack = slot.getItem();
            if (!player.getInventory().add(stack)) {
                player.drop(stack, false);
            }
            slot.set(ItemStack.EMPTY);
        }
        this.updatePlayerInventorySlots();
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (!this.isInAddingPhotographMode() || slotId < 0 || slotId >= this.slots.size()) {
            super.clicked(slotId, button, clickType, player);
            return;
        }
        Slot slot = (Slot)this.slots.get(slotId);
        ItemStack stack = slot.getItem();
        if (button == 0 && slot instanceof AlbumPlayerInventorySlot && stack.getItem() instanceof PhotographItem && this.getCarried().isEmpty()) {
            int pageIndex = this.getCurrentIndex();
            Optional<AlbumPhotographSlot> photographSlot = this.getCurrentPhotograph(pageIndex);
            if (photographSlot.isEmpty() || !photographSlot.get().getItem().isEmpty()) {
                return;
            }
            photographSlot.get().set(stack);
            slot.set(ItemStack.EMPTY);
            if (player.level().isClientSide) {
                player.playSound((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), 0.8f, 1.1f);
            }
            this.isAddingPhotograph = false;
            this.updatePlayerInventorySlots();
        } else {
            super.clicked(slotId, button, clickType, player);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return player.getInventory().getItem(this.pictureTapeSlot).getItem() instanceof PictureTapeItem;
    }
}

