/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.mehvahdjukaar.vista.VistaMod;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_1080;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7368;
import net.minecraft.class_7654;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import net.minecraft.class_7951;
import net.minecraft.class_8684;

public class GifPathSpriteSource
implements class_7948 {
    public static final MapCodec<GifPathSpriteSource> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.fieldOf("source").forGetter(l -> l.sourcePath), (App)Codec.STRING.fieldOf("prefix").forGetter(l -> l.idPrefix)).apply((Applicative)i, GifPathSpriteSource::new));
    public static final class_7951 TYPE = new class_7951(CODEC);
    private final String sourcePath;
    private final String idPrefix;

    public GifPathSpriteSource(String sourcePath, String idPrefix) {
        this.sourcePath = sourcePath;
        this.idPrefix = idPrefix;
    }

    public void method_47673(class_3300 resourceManager, class_7948.class_7949 output) {
        class_7654 fileToIdConverter = new class_7654("textures/" + this.sourcePath, ".gif");
        fileToIdConverter.method_45113(resourceManager).forEach((resourceLocation, resource) -> {
            class_2960 id = fileToIdConverter.method_45115(resourceLocation).method_45138(this.idPrefix);
            Optional optional = resourceManager.method_14486(resourceLocation);
            if (optional.isEmpty()) {
                VistaMod.LOGGER.warn("Unable to find texture {}", (Object)id);
            } else {
                output.method_47670(id, (class_7948.class_7950)new GifSpriteSupplier(id, (class_3298)optional.get()));
            }
        });
    }

    public class_7951 method_47672() {
        return TYPE;
    }

    private record GifSpriteSupplier(class_2960 id, class_3298 resource) implements class_7948.class_7950
    {
        private static final String GIF_IMAGE_META = "javax_imageio_gif_image_1.0";
        private static final String GIF_STREAM_META = "javax_imageio_gif_stream_1.0";

        /*
         * Enabled aggressive exception aggregation
         */
        public class_7764 apply(class_8684 spriteResourceLoader) {
            try (InputStream inputStream = this.resource.method_14482();){
                class_7764 class_77642;
                block14: {
                    ImageInputStream imageStream = ImageIO.createImageInputStream(inputStream);
                    try {
                        ImageReader reader = GifSpriteSupplier.gifReader(imageStream);
                        int frameCount = reader.getNumImages(true);
                        int[] wh = new int[2];
                        List<BufferedImage> frames = GifSpriteSupplier.readFramesComposited(reader, frameCount, wh);
                        List<Integer> frameTicks = GifSpriteSupplier.readFrameTicks(reader, frameCount);
                        int w = wh[0];
                        int h = wh[1];
                        class_1011 strip = GifSpriteSupplier.buildVerticalStrip(frames, w, h);
                        class_1079 anim = GifSpriteSupplier.buildAnimationMeta(frameTicks, w, h, frames.size());
                        class_7771 size = new class_7771(w, h);
                        class_7368 meta = new class_7368.class_8622().method_52448((class_3270)class_1079.field_5337, (Object)anim).method_52447();
                        class_77642 = new class_7764(this.id, size, strip, meta);
                        if (imageStream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (imageStream != null) {
                            try {
                                imageStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    imageStream.close();
                }
                return class_77642;
            }
            catch (IOException | IllegalArgumentException e) {
                VistaMod.LOGGER.error("unable to build animated strip for {}", (Object)this.id, (Object)e);
                return null;
            }
        }

        private static ImageReader gifReader(ImageInputStream iis) throws IOException {
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("gif");
            if (!it.hasNext()) {
                throw new IOException("No GIF ImageReader available");
            }
            ImageReader r = it.next();
            r.setInput(iis, false, false);
            return r;
        }

        private static List<Integer> readFrameTicks(ImageReader reader, int count) {
            ArrayList<Integer> ticks = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                int cs = 5;
                try {
                    IIOMetadata meta = reader.getImageMetadata(i);
                    IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(GIF_IMAGE_META);
                    IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                    if (gce != null) {
                        cs = Math.max(1, Integer.parseInt(gce.getAttribute("delayTime")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ticks.add(Math.max(1, Math.round((float)cs / 5.0f)));
            }
            return ticks;
        }

        private static List<BufferedImage> readFramesComposited(ImageReader reader, int count, int[] outWH) throws IOException {
            IIOMetadata streamMeta = reader.getStreamMetadata();
            int screenW = -1;
            int screenH = -1;
            int bgIndex = -1;
            Color bgColor = new Color(0, true);
            if (streamMeta != null) {
                IIOMetadataNode bg;
                IIOMetadataNode root = (IIOMetadataNode)streamMeta.getAsTree(GIF_STREAM_META);
                IIOMetadataNode lsd = (IIOMetadataNode)root.getElementsByTagName("LogicalScreenDescriptor").item(0);
                if (lsd != null) {
                    screenW = Integer.parseInt(lsd.getAttribute("logicalScreenWidth"));
                    screenH = Integer.parseInt(lsd.getAttribute("logicalScreenHeight"));
                }
                if ((bg = (IIOMetadataNode)root.getElementsByTagName("GlobalColorTable").item(0)) != null) {
                    String s = bg.getAttribute("backgroundColorIndex");
                    if (!s.isEmpty()) {
                        bgIndex = Integer.parseInt(s);
                    }
                    try {
                        int size = Integer.parseInt(bg.getAttribute("sizeOfGlobalColorTable"));
                        int[] r = new int[size];
                        int[] g = new int[size];
                        int[] b = new int[size];
                        for (int i = 0; i < size; ++i) {
                            IIOMetadataNode ce = (IIOMetadataNode)bg.getElementsByTagName("ColorTableEntry").item(i);
                            if (ce == null) continue;
                            r[i] = Integer.parseInt(ce.getAttribute("red"));
                            g[i] = Integer.parseInt(ce.getAttribute("green"));
                            b[i] = Integer.parseInt(ce.getAttribute("blue"));
                        }
                        if (bgIndex >= 0 && bgIndex < r.length) {
                            bgColor = new Color(r[bgIndex], g[bgIndex], b[bgIndex], 0);
                        }
                    }
                    catch (Exception size) {
                        // empty catch block
                    }
                }
            }
            if (screenW <= 0 || screenH <= 0) {
                BufferedImage first = reader.read(0);
                screenW = first.getWidth();
                screenH = first.getHeight();
            }
            outWH[0] = screenW;
            outWH[1] = screenH;
            BufferedImage canvas = new BufferedImage(screenW, screenH, 2);
            Graphics2D gCanvas = canvas.createGraphics();
            gCanvas.setComposite(AlphaComposite.SrcOver);
            gCanvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            BufferedImage prevSnapshot = null;
            ArrayList<BufferedImage> out = new ArrayList<BufferedImage>(count);
            block7: for (int i = 0; i < count; ++i) {
                IIOMetadata meta = reader.getImageMetadata(i);
                FrameMeta fm = GifSpriteSupplier.parseFrameMeta(meta);
                if (fm.disposal == 3) {
                    if (prevSnapshot == null || prevSnapshot.getWidth() != screenW || prevSnapshot.getHeight() != screenH) {
                        prevSnapshot = new BufferedImage(screenW, screenH, 2);
                    }
                    prevSnapshot.getRaster().setDataElements(0, 0, screenW, screenH, canvas.getRaster().getDataElements(0, 0, screenW, screenH, null));
                }
                BufferedImage frameImg = reader.read(i);
                gCanvas.drawImage((Image)frameImg, fm.left, fm.top, null);
                BufferedImage copy = new BufferedImage(screenW, screenH, 2);
                copy.getRaster().setDataElements(0, 0, screenW, screenH, canvas.getRaster().getDataElements(0, 0, screenW, screenH, null));
                out.add(copy);
                switch (fm.disposal) {
                    case 2: {
                        gCanvas.setComposite(AlphaComposite.Src);
                        gCanvas.setColor(bgColor);
                        gCanvas.fillRect(fm.left, fm.top, fm.width, fm.height);
                        gCanvas.setComposite(AlphaComposite.SrcOver);
                        continue block7;
                    }
                    case 3: {
                        if (prevSnapshot == null) continue block7;
                        canvas.getRaster().setDataElements(0, 0, screenW, screenH, prevSnapshot.getRaster().getDataElements(0, 0, screenW, screenH, null));
                    }
                }
            }
            gCanvas.dispose();
            if (out.isEmpty()) {
                throw new IOException("GIF contained no frames");
            }
            return out;
        }

        private static FrameMeta parseFrameMeta(IIOMetadata meta) {
            FrameMeta fm = new FrameMeta();
            try {
                String disp;
                IIOMetadataNode root = (IIOMetadataNode)meta.getAsTree(GIF_IMAGE_META);
                IIOMetadataNode id = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                fm.left = Integer.parseInt(id.getAttribute("imageLeftPosition"));
                fm.top = Integer.parseInt(id.getAttribute("imageTopPosition"));
                fm.width = Integer.parseInt(id.getAttribute("imageWidth"));
                fm.height = Integer.parseInt(id.getAttribute("imageHeight"));
                IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                fm.disposal = gce != null ? ("restoreToBackgroundColor".equals(disp = gce.getAttribute("disposalMethod")) ? 2 : ("restoreToPrevious".equals(disp) ? 3 : 1)) : 1;
            }
            catch (Exception ignored) {
                fm.top = 0;
                fm.left = 0;
                fm.height = 0;
                fm.width = 0;
                fm.disposal = 1;
            }
            return fm;
        }

        private static class_1011 buildVerticalStrip(List<BufferedImage> frames, int w, int h) {
            class_1011 out = new class_1011(class_1011.class_1012.field_4997, w, h * frames.size(), true);
            for (int i = 0; i < frames.size(); ++i) {
                int yOff = i * h;
                GifSpriteSupplier.copyArgbToAbgr(frames.get(i), out, 0, yOff, w, h);
            }
            return out;
        }

        private static void copyArgbToAbgr(BufferedImage src, class_1011 dst, int dx, int dy, int w, int h) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int argb = src.getRGB(x, y);
                    int a = argb >>> 24 & 0xFF;
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int abgr = a << 24 | b << 16 | g << 8 | r;
                    dst.method_4305(dx + x, dy + y, abgr);
                }
            }
        }

        private static class_1079 buildAnimationMeta(List<Integer> ticks, int w, int h, int frameCount) {
            if (ticks.size() < frameCount) {
                int last;
                int n = last = ticks.isEmpty() ? 1 : Math.max(1, ticks.get(ticks.size() - 1));
                while (ticks.size() < frameCount) {
                    ticks.add(last);
                }
            }
            boolean uniform = true;
            int first = Math.max(1, ticks.get(0));
            for (int i = 1; i < frameCount; ++i) {
                if (ticks.get(i).equals(first)) continue;
                uniform = false;
                break;
            }
            if (uniform) {
                int frameTime = first;
                return new class_1079(List.of(), w, h, Math.max(1, frameTime), false);
            }
            ArrayList<class_1080> frames = new ArrayList<class_1080>(frameCount);
            for (int i = 0; i < frameCount; ++i) {
                frames.add(new class_1080(i, Math.max(1, ticks.get(i))));
            }
            return new class_1079(frames, w, h, 1, false);
        }

        private static class FrameMeta {
            int left;
            int top;
            int width;
            int height;
            int disposal;

            private FrameMeta() {
            }
        }
    }
}

