/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.core.client.DummyCamera;
import net.mehvahdjukaar.vista.VistaMod;
import net.mehvahdjukaar.vista.client.ModRenderTypes;
import net.mehvahdjukaar.vista.common.ViewFinderBlockEntity;
import net.mehvahdjukaar.vista.common.ViewFinderConnection;
import net.mehvahdjukaar.vista.configs.ClientConfigs;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_6367;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_8113;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class LiveFeedRendererManager {
    private static final Int2ObjectArrayMap<class_276> CANVASES = new Int2ObjectArrayMap();
    private static final BiMap<UUID, class_2960> LIVE_FEED_LOCATIONS = HashBiMap.create();
    private static final DummyCamera DUMMY_CAMERA = new DummyCamera();
    private static long feedCounter = 0L;
    @Nullable
    public static class_276 LIVE_FEED_BEING_RENDERED = null;

    @Nullable
    public static class_2960 requestLiveFeedTexture(class_1937 level, UUID location, int size) {
        class_2960 feedId;
        FrameBufferBackedDynamicTexture texture;
        ViewFinderBlockEntity tile;
        ViewFinderConnection connection = ViewFinderConnection.get(level);
        if (connection != null && (tile = connection.getLinkedViewFinder(level, location)) != null && (texture = RenderedTexturesManager.requestTexture((class_2960)(feedId = LiveFeedRendererManager.getOrCreateFeedId(location)), (int)size, LiveFeedRendererManager::refreshTexture, (boolean)true)).isInitialized()) {
            return texture.getTextureLocation();
        }
        return null;
    }

    private static class_2960 getOrCreateFeedId(UUID uuid) {
        class_2960 loc = (class_2960)LIVE_FEED_LOCATIONS.get((Object)uuid);
        if (loc == null) {
            loc = VistaMod.res("live_feed_" + feedCounter++);
            LIVE_FEED_LOCATIONS.put((Object)uuid, (Object)loc);
        }
        return loc;
    }

    public static class_276 getOrCreateCanvas(int size) {
        class_276 canvas = (class_276)CANVASES.get(size);
        if (canvas == null) {
            canvas = new class_6367(size, size, true, class_310.field_1703);
            CANVASES.put(size, (Object)canvas);
        }
        return canvas;
    }

    public static void clear() {
        CANVASES.clear();
        LIVE_FEED_LOCATIONS.clear();
        LiveFeedRendererManager.DUMMY_CAMERA.field_18711 = null;
    }

    private static void refreshTexture(FrameBufferBackedDynamicTexture text) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (!mc.method_53466() || level == null) {
            return;
        }
        long gameTime = level.method_8510();
        if (gameTime % 5L != 0L) {
            return;
        }
        ViewFinderConnection connection = ViewFinderConnection.get((class_1937)level);
        if (connection == null) {
            return;
        }
        UUID uuid = (UUID)LIVE_FEED_LOCATIONS.inverse().get((Object)text.getTextureLocation());
        ViewFinderBlockEntity tile = connection.getLinkedViewFinder((class_1937)level, uuid);
        if (tile == null) {
            return;
        }
        float partialTicks = mc.method_60646().method_60636();
        LiveFeedRendererManager.setupSceneCamera(tile, partialTicks);
        class_276 renderTarget = text.getFrameBuffer();
        class_276 mainTarget = mc.method_1522();
        int size = text.getWidth();
        class_276 canvas = LiveFeedRendererManager.getOrCreateCanvas(size);
        canvas.method_1235(true);
        LIVE_FEED_BEING_RENDERED = canvas;
        float fov = 70.0f * tile.getModifiedFOV(1.0f, 1.0f);
        RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
        class_758.method_23792();
        RenderSystem.enableCull();
        float oldRenderDistance = mc.field_1773.field_4025;
        mc.field_1773.field_4025 = Math.min(oldRenderDistance, (float)ClientConfigs.RENDER_DISTANCE.get().intValue());
        LiveFeedRendererManager.renderLevel(mc, canvas, (class_4184)DUMMY_CAMERA, fov);
        mc.field_1773.field_4025 = oldRenderDistance;
        LiveFeedRendererManager.copyWithShader(canvas, renderTarget, ModRenderTypes.POSTERIZE.apply(canvas));
        LIVE_FEED_BEING_RENDERED = null;
        mainTarget.method_1235(true);
    }

    private static void setupSceneCamera(ViewFinderBlockEntity tile, float partialTicks) {
        class_1937 level = tile.method_10997();
        float pitch = tile.getPitch(partialTicks);
        float yaw = tile.getYaw(partialTicks);
        if (LiveFeedRendererManager.DUMMY_CAMERA.field_18711 == null) {
            LiveFeedRendererManager.DUMMY_CAMERA.field_18711 = new class_8113.class_8115(class_1299.field_42460, level);
        }
        class_1297 dummyCameraEntity = DUMMY_CAMERA.method_19331();
        class_243 pos = tile.method_11016().method_46558();
        dummyCameraEntity.method_33574(pos);
        dummyCameraEntity.method_36457(pitch);
        dummyCameraEntity.method_36456(yaw + 180.0f);
        DUMMY_CAMERA.method_19322(pos);
        DUMMY_CAMERA.method_19325(yaw, pitch);
    }

    private static void renderLevel(class_310 mc, class_276 target, class_4184 camera, float fov) {
        class_9779 deltaTracker = mc.method_60646();
        class_757 gr = mc.field_1773;
        class_761 lr = mc.field_1769;
        Matrix4f projMatrix = LiveFeedRendererManager.createProjectionMatrix(gr, target, fov);
        class_4587 poseStack = new class_4587();
        projMatrix.mul((Matrix4fc)poseStack.method_23760().method_23761());
        gr.method_22709(projMatrix);
        Quaternionf cameraRotation = camera.method_23767().conjugate(new Quaternionf());
        Matrix4f cameraMatrix = new Matrix4f().rotation((Quaternionfc)cameraRotation);
        lr.method_32133(camera.method_19326(), cameraMatrix, projMatrix);
        lr.method_22710(deltaTracker, false, camera, gr, gr.method_22974(), cameraMatrix, projMatrix);
        mc.method_16011().method_15405("neoforge_render_last");
        mc.method_16011().method_15407();
    }

    private static Matrix4f createProjectionMatrix(class_757 gr, class_276 target, float fov) {
        Matrix4f matrix4f = new Matrix4f();
        float zoom = 1.0f;
        if (zoom != 1.0f) {
            float zoomX = 0.0f;
            float zoomY = 0.0f;
            matrix4f.translate(zoomX, -zoomY, 0.0f);
            matrix4f.scale(zoom, zoom, 1.0f);
        }
        float depthFar = gr.method_32796();
        return matrix4f.perspective(fov * ((float)Math.PI / 180), (float)target.field_1482 / (float)target.field_1481, 0.05f, depthFar);
    }

    public static void copyWithShader(class_276 src, class_276 dst, class_1921 rt) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (src == null || dst == null) {
            throw new IllegalArgumentException("Source and destination RenderTargets cannot be null");
        }
        if (src.field_1476 <= 0 || dst.field_1476 <= 0) {
            throw new IllegalStateException("Both RenderTargets must have valid framebuffers");
        }
        if (src.method_30277() <= 0 || dst.method_30277() <= 0) {
            throw new IllegalStateException("Both RenderTargets must have valid color textures");
        }
        if (src.field_1482 != dst.field_1482 || src.field_1481 != dst.field_1481) {
            throw new IllegalStateException("RenderTarget sizes must match for shader copy");
        }
        dst.method_1230(true);
        dst.method_1235(true);
        RenderSystem.getModelViewMatrix().set((Matrix4fc)new Matrix4f().identity());
        RenderSystem.getProjectionMatrix().set((Matrix4fc)new Matrix4f().identity());
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 vc = bufferSource.getBuffer(rt);
        vc.method_22912(-1.0f, -1.0f, 0.0f).method_22913(0.0f, 1.0f);
        vc.method_22912(1.0f, -1.0f, 0.0f).method_22913(1.0f, 1.0f);
        vc.method_22912(1.0f, 1.0f, 0.0f).method_22913(1.0f, 0.0f);
        vc.method_22912(-1.0f, 1.0f, 0.0f).method_22913(0.0f, 0.0f);
        bufferSource.method_22994(rt);
    }
}

