/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.vista.integration.exposure;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumGUI;
import io.github.mortuusars.exposure.client.gui.screen.album.PhotographSlotWidget;
import io.github.mortuusars.exposure.client.gui.screen.element.Pager;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.TextBox;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBinding;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.world.inventory.slot.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.vista.integration.exposure.PictureTapeMenu;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PictureTapeScreen
extends class_465<PictureTapeMenu> {
    protected final Pager pager = new Pager().setChangeSound(new SoundEffect(() -> class_3417.field_17481)).onPageChanged((oldPage, newPage) -> this.clickButton(PagingDirection.fromChange((int)oldPage, (int)newPage).ordinal()));
    protected final KeyBindings keyBindings;
    protected final List<Page> pages;

    public PictureTapeScreen(PictureTapeMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        KeyBinding[] keyBindingArray = new KeyBinding[5];
        keyBindingArray[0] = Key.press((class_304)Minecrft.options().field_1822).executes(() -> ((PictureTapeScreen)this).method_25419());
        keyBindingArray[1] = Key.press((int)263).or(Key.press((int)65)).executes(() -> ((Pager)this.pager).previousPage());
        keyBindingArray[2] = Key.press((int)262).or(Key.press((int)68)).executes(() -> ((Pager)this.pager).nextPage());
        keyBindingArray[3] = Key.release((int)263).or(Key.press((int)65)).executes(() -> ((Pager)this.pager).resetCooldown());
        keyBindingArray[4] = Key.release((int)262).or(Key.press((int)68)).executes(() -> ((Pager)this.pager).resetCooldown());
        this.keyBindings = KeyBindings.of((KeyBinding[])keyBindingArray);
        this.pages = new ArrayList<Page>();
    }

    protected void method_25426() {
        this.field_2792 = 298;
        this.field_2779 = 188;
        super.method_25426();
        this.field_25268 = -999;
        this.field_25269 = 69;
        this.field_25270 = -999;
        this.pages.clear();
        Page leftPage = this.createPage(0);
        this.pages.add(leftPage);
        class_344 previousPageButton = new class_344(this.field_2776 + 12, this.field_2800 + 164, 13, 15, AlbumGUI.PREVIOUS_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        previousPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.previous_page")));
        this.method_37063((class_364)previousPageButton);
        class_344 nextPageButton = new class_344(this.field_2776 + 273, this.field_2800 + 164, 13, 15, AlbumGUI.NEXT_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        nextPageButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure.next_page")));
        this.method_37063((class_364)nextPageButton);
        int spreadsCount = (int)Math.ceil((float)((PictureTapeMenu)this.method_17577()).getTapeContent().size() / 2.0f);
        this.pager.setPagesCount(spreadsCount).setPreviousPageButton((class_4264)previousPageButton).setNextPageButton((class_4264)nextPageButton);
    }

    protected void method_37432() {
    }

    protected Page createPage(int xOffset) {
        int x = this.field_2776 + xOffset;
        int y = this.field_2800;
        class_768 page = new class_768(x, y, 149, 188);
        class_768 photo = new class_768(x + 25, y + 21, 108, 108);
        PhotographSlotWidget photographWidget = new PhotographSlotWidget((class_437)this, photo.method_3321(), photo.method_3322(), photo.method_3319(), photo.method_3320(), () -> ((PictureTapeMenu)this.method_17577()).getPhotograph()){

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return !PictureTapeScreen.this.isInAddingMode() && super.mouseClicked(mouseX, mouseY, button);
            }

            public boolean isHovered() {
                return !PictureTapeScreen.this.isInAddingMode() && super.isHovered();
            }
        };
        photographWidget.editable(true).primaryAction(widget -> {
            if (!widget.inspectPhotograph() && widget.getPhotograph().method_7960() && widget.isEditable()) {
                this.clickButton(2);
                Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
        }).secondaryAction(widget -> {
            if (widget.isEditable() && !widget.getPhotograph().method_7960()) {
                this.clickButton(2);
                Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)Exposure.SoundEvents.PHOTOGRAPH_PLACE.get()), (float)0.7f, (float)1.1f));
            }
        });
        this.method_37063((class_364)photographWidget);
        return new Page(photo, photographWidget);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateWidgetVisibility();
        this.field_25270 = this.isInAddingMode() ? ((PictureTapeMenu)this.method_17577()).getPlayerInventorySlots().getFirst().y - 12 : -999;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
        if (this.isInAddingMode()) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            for (class_1735 slot : ((PictureTapeMenu)this.method_17577()).field_7761) {
                if (slot.method_7677().method_7960() || slot.method_7677().method_7909() instanceof PhotographItem) continue;
                guiGraphics.method_25291(AlbumGUI.TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 350, 176.0f, 188.0f, 18, 18, 512, 512);
            }
            RenderSystem.disableBlend();
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    private void updateWidgetVisibility() {
        for (Page page : this.pages) {
            page.photographWidget.visible = !((PictureTapeMenu)this.method_17577()).getPhotograph().method_7960() || !this.isInAddingMode();
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        this.method_2389(guiGraphics, partialTick, mouseX, mouseY);
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 15.0f);
        super.method_2388(guiGraphics, mouseX, mouseY);
        guiGraphics.method_51448().method_22909();
    }

    protected void method_2380(class_332 guiGraphics, int x, int y) {
        if (this.isInAddingMode() && this.field_2787 != null && !this.field_2787.method_7677().method_7960() && !(this.field_2787.method_7677().method_7909() instanceof PhotographItem)) {
            return;
        }
        if (!this.isInAddingMode()) {
            for (Page page : this.pages) {
                if (!page.photographWidget.isHoveredOrFocused()) continue;
                page.photographWidget.renderTooltip(guiGraphics, x, y);
                return;
            }
        }
        super.method_2380(guiGraphics, x, y);
    }

    @NotNull
    public List<class_2561> method_51454(class_1799 stack) {
        List tooltipLines = super.method_51454(stack);
        if (this.isInAddingMode() && this.field_2787 != null && this.field_2787.method_7677() == stack && stack.method_7909() instanceof PhotographItem) {
            tooltipLines.add(class_2561.method_43473());
            tooltipLines.add(class_2561.method_43471((String)"gui.exposure.album.left_click_to_add"));
        }
        return tooltipLines;
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25291(AlbumGUI.TEXTURE, this.field_2776, this.field_2800, 0, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 512);
        int currentSpreadIndex = ((PictureTapeMenu)this.method_17577()).getCurrentIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex);
        if (this.isInAddingMode()) {
            AlbumPlayerInventorySlot firstSlot = ((PictureTapeMenu)this.method_17577()).getPlayerInventorySlots().getFirst();
            int x = firstSlot.x - 8;
            int y = firstSlot.y - 18;
            guiGraphics.method_25291(AlbumGUI.TEXTURE, this.field_2776 + x, this.field_2800 + y, 10, 0.0f, 188.0f, 176, 100, 512, 512);
            for (Page page : this.pages) {
                guiGraphics.method_52706(PhotographSlotWidget.EMPTY_SPRITES.comp_1606(), page.photoArea.method_3321(), page.photoArea.method_3322(), page.photoArea.method_3319(), page.photoArea.method_3320());
            }
        }
    }

    protected void drawPageNumbers(class_332 guiGraphics, int currentSpreadIndex) {
        class_327 font = Minecrft.get().field_1772;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.method_51433(font, leftPageNumber, this.field_2776 + 71 + (8 - font.method_1727(leftPageNumber) / 2), this.field_2800 + 167, -1, false);
        guiGraphics.method_51433(font, rightPageNumber, this.field_2776 + 212 + (8 - font.method_1727(rightPageNumber) / 2), this.field_2800 + 167, -1, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isInAddingMode()) {
            if (!(this.isHoveringOverInventory(mouseX, mouseY) || this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, button) && !((PictureTapeMenu)this.method_17577()).method_34255().method_7960())) {
                this.clickButton(-1);
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
        boolean handled = super.method_25402(mouseX, mouseY, button);
        if (!(this.method_25399() instanceof TextBox)) {
            this.method_25395(null);
        }
        return handled;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.field_2794 && !((PictureTapeMenu)this.method_17577()).method_34255().method_7960() && ((PictureTapeMenu)this.method_17577()).method_34255().method_7947() == 1) {
            this.field_2794 = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25430(@Nullable class_2583 style) {
        if (style == null) {
            return false;
        }
        class_2558 clickEvent = style.method_10970();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.method_10845() == class_2558.class_2559.field_11748) {
            String pageIndexStr = clickEvent.method_10844();
            int pageIndex = Integer.parseInt(pageIndexStr) - 1;
            this.forcePage(pageIndex);
            return true;
        }
        boolean handled = super.method_25430(style);
        if (handled && clickEvent.method_10845() == class_2558.class_2559.field_11750) {
            this.method_25419();
        }
        return handled;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isInAddingMode()) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return this.method_25399() != null && this.method_25397() && button == 0 && this.method_25399().method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    protected void clickButton(int buttonId) {
        ((PictureTapeMenu)this.method_17577()).method_7604((class_1657)Minecrft.player(), buttonId);
        Minecrft.gameMode().method_2900(((PictureTapeMenu)this.method_17577()).field_7763, buttonId);
        if (buttonId == -1) {
            this.method_25395(null);
        }
        if (buttonId == PictureTapeMenu.PREVIOUS_PAGE_BUTTON || buttonId == PictureTapeMenu.NEXT_PAGE_BUTTON) {
            // empty if block
        }
    }

    protected boolean isHoveringOverInventory(double mouseX, double mouseY) {
        if (!this.isInAddingMode()) {
            return false;
        }
        AlbumPlayerInventorySlot firstSlot = ((PictureTapeMenu)this.method_17577()).getPlayerInventorySlots().getFirst();
        int x = firstSlot.x - 8;
        int y = firstSlot.y - 18;
        return this.method_2378(x, y, 176, 100, mouseX, mouseY);
    }

    protected boolean method_2381(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return super.method_2381(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !this.isHoveringOverInventory(mouseX, mouseY);
    }

    protected boolean forcePage(int pageIndex) {
        try {
            int newSpreadIndex = pageIndex / 2;
            if (newSpreadIndex == ((PictureTapeMenu)this.method_17577()).getCurrentIndex() || newSpreadIndex < 0 || newSpreadIndex > ((PictureTapeMenu)this.method_17577()).getTapeContent().size() / 2) {
                return false;
            }
            PagingDirection pagingDirection = newSpreadIndex < ((PictureTapeMenu)this.method_17577()).getCurrentIndex() ? PagingDirection.PREVIOUS : PagingDirection.NEXT;
            for (int pageChanges = 0; !(newSpreadIndex == ((PictureTapeMenu)this.method_17577()).getCurrentIndex() && this.pager.canChangePage(pagingDirection) || pageChanges > 16); ++pageChanges) {
                this.pager.changePage(pagingDirection);
            }
            return true;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot force page: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 258) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.isInAddingMode() && (Minecrft.options().field_1822.method_1417(keyCode, scanCode) || keyCode == 256)) {
            this.clickButton(-1);
            return true;
        }
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    protected boolean isInAddingMode() {
        return ((PictureTapeMenu)this.method_17577()).isInAddingPhotographMode();
    }

    protected void forEachPage(Consumer<Page> pageAction) {
        for (Page page : this.pages) {
            pageAction.accept(page);
        }
    }

    protected class Page {
        public final class_768 photoArea;
        public final PhotographSlotWidget photographWidget;

        private Page(class_768 photoArea, PhotographSlotWidget photographWidget) {
            this.photoArea = photoArea;
            this.photographWidget = photographWidget;
        }

        public boolean isMouseOver(class_768 area, double mouseX, double mouseY) {
            return PictureTapeScreen.this.method_2378(area.method_3321() - PictureTapeScreen.this.field_2776, area.method_3322() - PictureTapeScreen.this.field_2800, area.method_3319(), area.method_3320(), mouseX, mouseY);
        }
    }
}

