/*
 * Decompiled with CFR 0.152.
 */
package fuzs.vehicleupgrade.client.handler;

import fuzs.vehicleupgrade.VehicleUpgrade;
import fuzs.vehicleupgrade.config.ClientConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.objects.AtlasSprite;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class EntityAttributesHandler {
    private static final ResourceLocation ARMOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
    private static final ResourceLocation HEART_VEHICLE_FULL_SPRITE = VehicleUpgrade.id("hud/heart/vehicle_full");

    public static void onAfterBackground(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (screen instanceof HorseInventoryScreen) {
            HorseInventoryScreen horseInventoryScreen = (HorseInventoryScreen)screen;
            if (horseInventoryScreen.horse.getInventoryColumns() == 0) {
                EntityAttributesHandler.renderMobAttributes(screen, guiGraphics, (Mob)horseInventoryScreen.horse);
            }
        }
    }

    public static void renderMobAttributes(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, Mob mob) {
        if (!((ClientConfig)VehicleUpgrade.CONFIG.get(ClientConfig.class)).mobAttributesInInventory) {
            return;
        }
        if (mob.getHealth() > 0.0f) {
            EntityAttributesHandler.submitAttributeComponent(screen, guiGraphics, EntityAttributesHandler.getValueComponent(Mth.ceil((float)mob.getHealth()), Mth.ceil((float)mob.getMaxHealth()), HEART_VEHICLE_FULL_SPRITE), 124, 32);
        }
        if (mob.getArmorValue() > 0) {
            EntityAttributesHandler.submitAttributeComponent(screen, guiGraphics, EntityAttributesHandler.getValueComponent(mob.getArmorValue(), ARMOR_FULL_SPRITE), 124, 48);
        }
    }

    private static Component getValueComponent(int value, ResourceLocation resourceLocation) {
        return Component.literal((String)(value + "x")).append((Component)Component.object((ObjectInfo)new AtlasSprite(AtlasIds.GUI, resourceLocation)).withColor(-1));
    }

    private static Component getValueComponent(int value, int maxValue, ResourceLocation resourceLocation) {
        return Component.empty().append(EntityAttributesHandler.getValueComponent(value, resourceLocation)).append(" / ").append(EntityAttributesHandler.getValueComponent(maxValue, resourceLocation));
    }

    private static void submitAttributeComponent(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, Component component, int posX, int posY) {
        guiGraphics.drawString(screen.getFont(), component, screen.leftPos + posX - screen.getFont().width((FormattedText)component) / 2, screen.topPos + posY, -12566464, false);
    }
}

